package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Listado;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class VendedorListadoVendedorRequest {

    private Listado listado;
    private Vendedor vendedor;

    public VendedorListadoVendedorRequest() {
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    @Override
    public String toString() {
        return "VendedorListadoVendedorRequest ["
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((vendedor != null) ? "vendedor=" + vendedor : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorListadoVendedorRequest that = (VendedorListadoVendedorRequest) o;

        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        return vendedor != null ? vendedor.equals(that.vendedor) : that.vendedor == null;
    }

    @Override
    public int hashCode() {
        int result = listado != null ? listado.hashCode() : 0;
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        return result;
    }
}
