package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.DatosGenerador;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RespuestaDebinRequest {

    private String id;
    private String ori_trx;
    private Respuesta respuesta;
    private DatosGenerador datosGenerador;

    public enum RespuestaDebinCodigo {
        ACEPTADO_CLIENTE("01"),
        RECHAZADO_CLIENTE("10"),
        OTROS_PROBLEMAS("40");

        private String code;
        RespuestaDebinCodigo(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOri_trx() {
        return ori_trx;
    }

    public void setOri_trx(String ori_trx) {
        this.ori_trx = ori_trx;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public DatosGenerador getDatosGenerador() {
        return datosGenerador;
    }

    public void setDatosGenerador(DatosGenerador datosGenerador) {
        this.datosGenerador = datosGenerador;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        RespuestaDebinRequest that = (RespuestaDebinRequest) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (ori_trx != null ? !ori_trx.equals(that.ori_trx) : that.ori_trx != null) return false;
        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return datosGenerador != null ? datosGenerador.equals(that.datosGenerador) : that.datosGenerador == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (ori_trx != null ? ori_trx.hashCode() : 0);
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        result = 31 * result + (datosGenerador != null ? datosGenerador.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RespuestaDebinRequest [" +
                "id=" + id +
                ", ori_trx=" + ori_trx +
                ", respuesta=" + respuesta +
                ", datosGenerador=" + datosGenerador +
                ']';
    }
}
