package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdherirRecurrenciaVendedorResponse {

    private Respuesta respuesta;

    private Integer id;

    public AdherirRecurrenciaVendedorResponse() {
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "AdherirRecurrenciaVendedorResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((id != null) ? "id=" + id : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdherirRecurrenciaVendedorResponse that = (AdherirRecurrenciaVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        return result;
    }
}
