package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CuentaAlias {

    private String nro_cbu;
    private String nro_cbu_anterior;
    private String nro_bco;
    private String cta_activa;
    private DebinConst.TipoCuentaAlias tipo_cta;

    public CuentaAlias() {

    }

    public String getNro_cbu() {
        return nro_cbu;
    }

    public void setNro_cbu(String nro_cbu) {
        this.nro_cbu = nro_cbu;
    }

    public DebinConst.TipoCuentaAlias getTipo_cta() {
        return tipo_cta;
    }

    public void setTipo_cta(DebinConst.TipoCuentaAlias tipo_cta) {
        this.tipo_cta = tipo_cta;
    }

    public String getNro_cbu_anterior() {
        return nro_cbu_anterior;
    }

    public void setNro_cbu_anterior(String nro_cbu_anterior) {
        this.nro_cbu_anterior = nro_cbu_anterior;
    }

    public String getNro_bco() {
        return nro_bco;
    }

    public void setNro_bco(String nro_bco) {
        this.nro_bco = nro_bco;
    }

    public String getCta_activa() {
        return cta_activa;
    }

    public void setCta_activa(String cta_activa) {
        this.cta_activa = cta_activa;
    }

    @Override
    public String toString() {
        return "CuentaAlias [" +
                "nro_cbu=" + nro_cbu +
                ", nro_cbu_anterior=" + nro_cbu_anterior +
                ", nro_bco=" + nro_bco +
                ", cta_activa=" + cta_activa +
                ", tipo_cta=" + tipo_cta +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CuentaAlias that = (CuentaAlias) o;

        if (nro_cbu != null ? !nro_cbu.equals(that.nro_cbu) : that.nro_cbu != null) return false;
        if (nro_cbu_anterior != null ? !nro_cbu_anterior.equals(that.nro_cbu_anterior) : that.nro_cbu_anterior != null) return false;
        if (nro_bco != null ? !nro_bco.equals(that.nro_bco) : that.nro_bco != null) return false;
        if (cta_activa != null ? !cta_activa.equals(that.cta_activa) : that.cta_activa != null) return false;
        return tipo_cta == that.tipo_cta;
    }

    @Override
    public int hashCode() {
        int result = nro_cbu != null ? nro_cbu.hashCode() : 0;
        result = 31 * result + (nro_cbu_anterior != null ? nro_cbu_anterior.hashCode() : 0);
        result = 31 * result + (nro_bco != null ? nro_bco.hashCode() : 0);
        result = 31 * result + (cta_activa != null ? cta_activa.hashCode() : 0);
        result = 31 * result + (tipo_cta != null ? tipo_cta.hashCode() : 0);
        return result;
    }
}
