package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Originante {

    private String cuit;
    private String banco;
    private String sucursal;
    private String cbu;
    private String titular;

    public Originante() {

    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    @Override
    public String toString() {
        return "Originante ["
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((sucursal != null) ? "sucursal=" + sucursal + ", " : "")
                + ((cbu != null) ? "cbu=" + cbu + ", " : "")
                + ((titular != null) ? "titular=" + titular : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Originante that = (Originante) o;

        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (banco != null ? !banco.equals(that.banco) : that.banco != null) return false;
        if (sucursal != null ? !sucursal.equals(that.sucursal) : that.sucursal != null) return false;
        if (cbu != null ? !cbu.equals(that.cbu) : that.cbu != null) return false;
        return titular != null ? titular.equals(that.titular) : that.titular == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (banco != null ? banco.hashCode() : 0);
        result = 31 * result + (sucursal != null ? sucursal.hashCode() : 0);
        result = 31 * result + (cbu != null ? cbu.hashCode() : 0);
        result = 31 * result + (titular != null ? titular.hashCode() : 0);
        return result;
    }
}
