package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;


import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Creacion {

    //Hay dos formatos, because Coelsa...

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaDesde;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaHasta;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fecha_desde;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fecha_hasta;

    public Date getFechaDesde() {
        return fechaDesde;
    }

    public void setFechaDesde(Date fechaDesde) {
        this.fechaDesde = fechaDesde;
    }

    public Date getFechaHasta() {
        return fechaHasta;
    }

    public void setFechaHasta(Date fechaHasta) {
        this.fechaHasta = fechaHasta;
    }

    public Date getFecha_desde() {
        return fecha_desde;
    }

    public void setFecha_desde(Date fecha_desde) {
        this.fecha_desde = fecha_desde;
    }

    public Date getFecha_hasta() {
        return fecha_hasta;
    }

    public void setFecha_hasta(Date fecha_hasta) {
        this.fecha_hasta = fecha_hasta;
    }

    @Override
    public String toString() {
        return "Creacion ["
                + ((fechaDesde != null) ? "fechaDesde=" + fechaDesde + ", " : "")
                + ((fechaHasta != null) ? "fechaHasta=" + fechaHasta + ", " : "")
                + ((fecha_desde != null) ? "fecha_desde=" + fecha_desde + ", " : "")
                + ((fecha_hasta != null) ? "fecha_hasta=" + fecha_hasta : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Creacion creacion = (Creacion) o;

        if (fechaDesde != null ? !fechaDesde.equals(creacion.fechaDesde) : creacion.fechaDesde != null) return false;
        if (fechaHasta != null ? !fechaHasta.equals(creacion.fechaHasta) : creacion.fechaHasta != null) return false;
        if (fecha_desde != null ? !fecha_desde.equals(creacion.fecha_desde) : creacion.fecha_desde != null)
            return false;
        return fecha_hasta != null ? fecha_hasta.equals(creacion.fecha_hasta) : creacion.fecha_hasta == null;
    }

    @Override
    public int hashCode() {
        int result = fechaDesde != null ? fechaDesde.hashCode() : 0;
        result = 31 * result + (fechaHasta != null ? fechaHasta.hashCode() : 0);
        result = 31 * result + (fecha_desde != null ? fecha_desde.hashCode() : 0);
        result = 31 * result + (fecha_hasta != null ? fecha_hasta.hashCode() : 0);
        return result;
    }
}
