package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Prestacion;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarPrestacionVendedorResponse {

    private Respuesta respuesta;
    private Collection<Prestacion> prestaciones;

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Collection<Prestacion> getPrestaciones() {
        return prestaciones;
    }

    public void setPrestaciones(Collection<Prestacion> prestaciones) {
        this.prestaciones = prestaciones;
    }

    @Override
    public String toString() {
        return "ConsultarPrestacionVendedorResponse ["
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((prestaciones != null) ? "prestaciones=" + Arrays.toString(prestaciones.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarPrestacionVendedorResponse that = (ConsultarPrestacionVendedorResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        return prestaciones != null ? prestaciones.equals(that.prestaciones) : that.prestaciones == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (prestaciones != null ? prestaciones.hashCode() : 0);
        return result;
    }
}
