package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class Alias {

    private String valor;

    @JsonProperty("valor_original")
    private String valorOriginal;

    private String id;

    public String getValor() {
        return valor;
    }

    public void setValor(String valor) {
        this.valor = valor;
    }

    public String getValorOriginal() {
        return valorOriginal;
    }

    public void setValorOriginal(String valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return "Alias [" +
                ((valor != null) ? "valor='" + valor + "', " : "") +
                ((valorOriginal != null) ? "valorOriginal='" + valorOriginal + "', " : "") +
                ((id != null) ? "id='" + id + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Alias alias = (Alias) o;
        return Objects.equals(valor, alias.valor) && Objects.equals(valorOriginal, alias.valorOriginal) && Objects.equals(id, alias.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valor, valorOriginal, id);
    }
}