package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Recurrencia {

    private Integer id;
    private String estado;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaCreacion;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fecha_creacion;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fecha_confirmacion;
    private Vendedor vendedor;
    private Comprador comprador;
    private Boolean activo;
    private Debin debin;
    private Respuesta respuesta;
    private Integer tipo_adhesion;
    private String cuit_creacion;
    private String autorizado;

    public Recurrencia() {
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public Date getFechaCreacion() {
        return fechaCreacion;
    }

    public void setFechaCreacion(Date fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    public Date getFecha_creacion() {
        return fecha_creacion;
    }

    public void setFecha_creacion(Date fecha_creacion) {
        this.fecha_creacion = fecha_creacion;
    }

    public Date getFecha_confirmacion() {
        return fecha_confirmacion;
    }

    public void setFecha_confirmacion(Date fecha_confirmacion) {
        this.fecha_confirmacion = fecha_confirmacion;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Debin getDebin() {
        return debin;
    }

    public void setDebin(Debin debin) {
        this.debin = debin;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getActivo() {
        return activo;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Integer getTipo_adhesion() {
        return tipo_adhesion;
    }

    public void setTipo_adhesion(Integer tipo_adhesion) {
        this.tipo_adhesion = tipo_adhesion;
    }

    public String getCuit_creacion() {
        return cuit_creacion;
    }

    public void setCuit_creacion(String cuit_creacion) {
        this.cuit_creacion = cuit_creacion;
    }

    public String getAutorizado() {
        return autorizado;
    }

    public void setAutorizado(String autorizado) {
        this.autorizado = autorizado;
    }

    @Override
    public String toString() {
        return "Recurrencia [" +
                ((id != null) ? "id=" + id + ", " : "") +
                ((estado != null) ? "estado='" + estado + "', " : "") +
                ((fechaCreacion != null) ? "fechaCreacion=" + fechaCreacion + ", " : "") +
                ((fecha_creacion != null) ? "fecha_creacion=" + fecha_creacion + ", " : "") +
                ((fecha_confirmacion != null) ? "fecha_confirmacion=" + fecha_confirmacion + ", " : "") +
                ((vendedor != null) ? "vendedor=" + vendedor + ", " : "") +
                ((comprador != null) ? "comprador=" + comprador + ", " : "") +
                ((activo != null) ? "activo=" + activo + ", " : "") +
                ((debin != null) ? "debin=" + debin + ", " : "") +
                ((respuesta != null) ? "respuesta=" + respuesta + ", " : "") +
                ((tipo_adhesion != null) ? "tipo_adhesion=" + tipo_adhesion + ", " : "") +
                ((cuit_creacion != null) ? "cuit_creacion='" + cuit_creacion + "', " : "") +
                ((autorizado != null) ? "autorizado='" + autorizado + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Recurrencia that = (Recurrencia) o;
        return Objects.equals(id, that.id) && Objects.equals(estado, that.estado) && Objects.equals(fechaCreacion, that.fechaCreacion) && Objects.equals(fecha_creacion, that.fecha_creacion) && Objects.equals(fecha_confirmacion, that.fecha_confirmacion) && Objects.equals(vendedor, that.vendedor) && Objects.equals(comprador, that.comprador) && Objects.equals(activo, that.activo) && Objects.equals(debin, that.debin) && Objects.equals(respuesta, that.respuesta) && Objects.equals(tipo_adhesion, that.tipo_adhesion) && Objects.equals(cuit_creacion, that.cuit_creacion) && Objects.equals(autorizado, that.autorizado);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, estado, fechaCreacion, fecha_creacion, fecha_confirmacion, vendedor, comprador, activo, debin, respuesta, tipo_adhesion, cuit_creacion, autorizado);
    }
}