package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Comprador;
import ar.com.sdd.debin.entity.Debin;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConfirmarRecurrenciaCompradorRequest implements Serializable {

    @JsonProperty("comprador")
    private Comprador comprador;

    @JsonProperty("vendedor")
    private Vendedor vendedor;

    @JsonProperty("debin")
    private Debin debin;

    @JsonProperty("id")
    private Integer id;

    @JsonProperty("autorizacion")
    private Boolean autorizacion;

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Debin getDebin() {
        return debin;
    }

    public void setDebin(Debin debin) {
        this.debin = debin;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getAutorizacion() {
        return autorizacion;
    }

    public void setAutorizacion(Boolean autorizacion) {
        this.autorizacion = autorizacion;
    }

    @Override
    public String toString() {
        return "ConfirmarRecurrenciaCompradorRequest [" +
                ((comprador != null) ? "comprador=" + comprador + ", " : "") +
                ((vendedor != null) ? "vendedor=" + vendedor + ", " : "") +
                ((debin != null) ? "debin=" + debin + ", " : "") +
                ((id != null) ? "id=" + id + ", " : "") +
                ((autorizacion != null) ? "autorizacion=" + autorizacion + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConfirmarRecurrenciaCompradorRequest that = (ConfirmarRecurrenciaCompradorRequest) o;
        return Objects.equals(comprador, that.comprador) && Objects.equals(vendedor, that.vendedor) && Objects.equals(debin, that.debin) && Objects.equals(id, that.id) && Objects.equals(autorizacion, that.autorizacion);
    }

    @Override
    public int hashCode() {
        if (this.id != null) return this.id.hashCode();
        return Objects.hash(comprador, vendedor, debin, id, autorizacion);
    }
}