package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Comprador;
import ar.com.sdd.debin.entity.OperacionOriginal;
import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SolicitudContraCargoCompradorRequest implements Serializable {

    private OperacionOriginal operacionOriginal;
    private Comprador comprador;
    private Vendedor vendedor;

    public SolicitudContraCargoCompradorRequest() {}

    public OperacionOriginal getOperacionOriginal() {
        return operacionOriginal;
    }

    public void setOperacionOriginal(OperacionOriginal operacionOriginal) {
        this.operacionOriginal = operacionOriginal;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SolicitudContraCargoCompradorRequest that = (SolicitudContraCargoCompradorRequest) o;

        if (operacionOriginal != null ? !operacionOriginal.equals(that.operacionOriginal) : that.operacionOriginal != null)
            return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        return vendedor != null ? vendedor.equals(that.vendedor) : that.vendedor == null;
    }

    @Override
    public int hashCode() {
        int result = operacionOriginal != null ? operacionOriginal.hashCode() : 0;
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SolicitudContraCargoCompradorRequest [" +
                "operacionOriginal=" + operacionOriginal +
                ", comprador=" + comprador +
                ", vendedor=" + vendedor +
                ']';
    }
}
