package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Cuenta implements Serializable {

    private String banco;
    private String sucursal;
    private String terminal;
    private String alias;
    private String cbu;
    private Boolean esTitular;
    private List<String> titulares;
    private DebinConst.Moneda moneda;
    private String tipo;
    private String endpointId;
    private String cuit;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date alta;

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getTerminal() {
        return terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public Boolean getEsTitular() {
        return esTitular;
    }

    public void setEsTitular(Boolean esTitular) {
        this.esTitular = esTitular;
    }

    public List<String> getTitulares() {
        return titulares;
    }

    public void setTitulares(List<String> titulares) {
        this.titulares = titulares;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getEndpointId() {
        return endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public Date getAlta() {
        return alta;
    }

    public void setAlta(Date alta) {
        this.alta = alta;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public String toString() {
        return "Cuenta [" +
                ((banco != null) ? "banco='" + banco + "', " : "") +
                ((sucursal != null) ? "sucursal='" + sucursal + "', " : "") +
                ((terminal != null) ? "terminal='" + terminal + "', " : "") +
                ((alias != null) ? "alias='" + alias + "', " : "") +
                ((cbu != null) ? "cbu='" + cbu + "', " : "") +
                ((esTitular != null) ? "esTitular=" + esTitular + ", " : "") +
                ((titulares != null) ? "titulares=" + Arrays.toString(titulares.toArray()) + ", " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                ((tipo != null) ? "tipo='" + tipo + "', " : "") +
                ((endpointId != null) ? "endpointId='" + endpointId + "', " : "") +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((alta != null) ? "alta=" + alta + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Cuenta cuenta = (Cuenta) o;
        return Objects.equals(banco, cuenta.banco) && Objects.equals(sucursal, cuenta.sucursal) && Objects.equals(terminal, cuenta.terminal) && Objects.equals(alias, cuenta.alias) && Objects.equals(cbu, cuenta.cbu) && Objects.equals(esTitular, cuenta.esTitular) && Objects.equals(titulares, cuenta.titulares) && moneda == cuenta.moneda && Objects.equals(tipo, cuenta.tipo) && Objects.equals(endpointId, cuenta.endpointId) && Objects.equals(cuit, cuenta.cuit) && Objects.equals(alta, cuenta.alta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(banco, sucursal, terminal, alias, cbu, esTitular, titulares, moneda, tipo, endpointId, cuit, alta);
    }
}