package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class CommonError implements Serializable {

    @JsonProperty("url")
    private String url;

    @JsonProperty("ex")
    private String ex;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEx() {
        return ex;
    }

    public void setEx(String ex) {
        this.ex = ex;
    }

    @Override
    public String toString() {
        return "CommonError [" +
                ((url != null) ? "url=" + url + ", " : "") +
                ((ex != null) ? "ex='" + ex + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CommonError that = (CommonError) o;
        return Objects.equals(url, that.url) && Objects.equals(ex, that.ex);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, ex);
    }
}