package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Evaluacion {

    private Integer puntaje;
    private String reglas;

    public Evaluacion() {}

    public Integer getPuntaje() {
        return puntaje;
    }

    public void setPuntaje(Integer puntaje) {
        this.puntaje = puntaje;
    }

    public String getReglas() {
        return reglas;
    }

    public void setReglas(String reglas) {
        this.reglas = reglas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Evaluacion that = (Evaluacion) o;

        if (puntaje != null ? !puntaje.equals(that.puntaje) : that.puntaje != null) return false;
        return reglas != null ? reglas.equals(that.reglas) : that.reglas == null;
    }

    @Override
    public int hashCode() {
        int result = puntaje != null ? puntaje.hashCode() : 0;
        result = 31 * result + (reglas != null ? reglas.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Evaluacion [" +
                "puntaje=" + puntaje +
                ", reglas=" + reglas +
                ']';
    }
}
