package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Cvu {

    private String psp_id;
    private String cta_id;
    private String cvu;
    private String tipo;
    private String cuit;
    private String titular;
    private DebinConst.Moneda moneda;
    private String persona_tipo;
    private Estado estado;

    public Cvu() {

    }

    public String getPsp_id() {
        return psp_id;
    }

    public void setPsp_id(String psp_id) {
        this.psp_id = psp_id;
    }

    public String getCta_id() {
        return cta_id;
    }

    public void setCta_id(String cta_id) {
        this.cta_id = cta_id;
    }

    public String getCvu() {
        return cvu;
    }

    public void setCvu(String cvu) {
        this.cvu = cvu;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public String getPersona_tipo() {
        return persona_tipo;
    }

    public void setPersona_tipo(String persona_tipo) {
        this.persona_tipo = persona_tipo;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    @Override
    public String toString() {
        return "Cvu ["
                + ((psp_id != null) ? "psp_id=" + psp_id + ", " : "")
                + ((cta_id != null) ? "cta_id=" + cta_id + ", " : "")
                + ((cvu != null) ? "cvu=" + cvu + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((titular != null) ? "titular=" + titular + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((persona_tipo != null) ? "persona_tipo=" + persona_tipo + ", " : "")
                + ((estado != null) ? "estado=" + estado : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Cvu cvu1 = (Cvu) o;

        if (psp_id != null ? !psp_id.equals(cvu1.psp_id) : cvu1.psp_id != null) return false;
        if (cta_id != null ? !cta_id.equals(cvu1.cta_id) : cvu1.cta_id != null) return false;
        if (cvu != null ? !cvu.equals(cvu1.cvu) : cvu1.cvu != null) return false;
        if (tipo != null ? !tipo.equals(cvu1.tipo) : cvu1.tipo != null) return false;
        if (cuit != null ? !cuit.equals(cvu1.cuit) : cvu1.cuit != null) return false;
        if (titular != null ? !titular.equals(cvu1.titular) : cvu1.titular != null) return false;
        if (moneda != cvu1.moneda) return false;
        if (persona_tipo != null ? !persona_tipo.equals(cvu1.persona_tipo) : cvu1.persona_tipo != null) return false;
        return estado != null ? estado.equals(cvu1.estado) : cvu1.estado == null;
    }

    @Override
    public int hashCode() {
        int result = psp_id != null ? psp_id.hashCode() : 0;
        result = 31 * result + (cta_id != null ? cta_id.hashCode() : 0);
        result = 31 * result + (cvu != null ? cvu.hashCode() : 0);
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (titular != null ? titular.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (persona_tipo != null ? persona_tipo.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        return result;
    }
}