package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Listado {

    private Integer tamano;
    private Integer pagina;
    private Integer paginasTotales;
    private Integer paginas_totales;

    public Integer getPaginasTotales() {
        return paginasTotales;
    }

    public void setPaginasTotales(Integer paginasTotales) {
        this.paginasTotales = paginasTotales;
    }

    public Integer getTamano() {
        return tamano;
    }

    public void setTamano(Integer tamano) {
        this.tamano = tamano;
    }

    public Integer getPagina() {
        return pagina;
    }

    public void setPagina(Integer pagina) {
        this.pagina = pagina;
    }

    public Integer getPaginas_totales() {
        return paginas_totales;
    }

    public void setPaginas_totales(Integer paginas_totales) {
        this.paginas_totales = paginas_totales;
    }

    @Override
    public String toString() {
        return "Listado [" +
                ((tamano != null) ? "tamano=" + tamano + ", " : "") +
                ((pagina != null) ? "pagina=" + pagina + ", " : "") +
                ((paginasTotales != null) ? "paginasTotales=" + paginasTotales + ", " : "") +
                ((paginas_totales != null) ? "paginas_totales=" + paginas_totales + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Listado listado = (Listado) o;
        return Objects.equals(tamano, listado.tamano) && Objects.equals(pagina, listado.pagina) && Objects.equals(paginasTotales, listado.paginasTotales) && Objects.equals(paginas_totales, listado.paginas_totales);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tamano, pagina, paginasTotales, paginas_totales);
    }
}