package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Ubicacion {

    private BigDecimal lat;
    private BigDecimal lng;
    private BigDecimal precision;

    public Ubicacion() {
    }

    public BigDecimal getLat() {
        return lat;
    }

    public void setLat(BigDecimal lat) {
        this.lat = lat;
    }

    public BigDecimal getLng() {
        return lng;
    }

    public void setLng(BigDecimal lng) {
        this.lng = lng;
    }

    public BigDecimal getPrecision() {
        return precision;
    }

    public void setPrecision(BigDecimal precision) {
        this.precision = precision;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Ubicacion ubicacion = (Ubicacion) o;

        if (lat != null ? !lat.equals(ubicacion.lat) : ubicacion.lat != null) return false;
        if (lng != null ? !lng.equals(ubicacion.lng) : ubicacion.lng != null) return false;
        return precision != null ? precision.equals(ubicacion.precision) : ubicacion.precision == null;
    }

    @Override
    public int hashCode() {
        int result = lat != null ? lat.hashCode() : 0;
        result = 31 * result + (lng != null ? lng.hashCode() : 0);
        result = 31 * result + (precision != null ? precision.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Ubicacion [" +
                "lat=" + lat +
                ", lng=" + lng +
                ", precision=" + precision +
                ']';
    }
}
