package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Recurrencia {

    private Integer id;
    private String estado;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaCreacion;
    private Vendedor vendedor;
    private Comprador comprador;
    private Boolean activo;
    private Debin debin;
    private Respuesta respuesta;
    private Integer tipo_adhesion;
    private String cuit_creacion;

    public Recurrencia() {
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    public Date getFechaCreacion() {
        return fechaCreacion;
    }

    public void setFechaCreacion(Date fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Debin getDebin() {
        return debin;
    }

    public void setDebin(Debin debin) {
        this.debin = debin;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getActivo() {
        return activo;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Integer getTipo_adhesion() {
        return tipo_adhesion;
    }

    public void setTipo_adhesion(Integer tipo_adhesion) {
        this.tipo_adhesion = tipo_adhesion;
    }

    public String getCuit_creacion() {
        return cuit_creacion;
    }

    public void setCuit_creacion(String cuit_creacion) {
        this.cuit_creacion = cuit_creacion;
    }

    @Override
    public String toString() {
        return "Recurrencia ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((estado != null) ? "estado=" + estado + ", " : "")
                + ((fechaCreacion != null) ? "fechaCreacion=" + fechaCreacion + ", " : "")
                + ((vendedor != null) ? "vendedor=" + vendedor + ", " : "")
                + ((comprador != null) ? "comprador=" + comprador + ", " : "")
                + ((activo != null) ? "activo=" + activo + ", " : "")
                + ((debin != null) ? "debin=" + debin + ", " : "")
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((tipo_adhesion != null) ? "tipo_adhesion=" + tipo_adhesion + ", " : "")
                + ((cuit_creacion != null) ? "cuit_creacion=" + cuit_creacion : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Recurrencia that = (Recurrencia) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (estado != null ? !estado.equals(that.estado) : that.estado != null) return false;
        if (fechaCreacion != null ? !fechaCreacion.equals(that.fechaCreacion) : that.fechaCreacion != null)
            return false;
        if (vendedor != null ? !vendedor.equals(that.vendedor) : that.vendedor != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        if (activo != null ? !activo.equals(that.activo) : that.activo != null) return false;
        if (debin != null ? !debin.equals(that.debin) : that.debin != null) return false;
        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (tipo_adhesion != null ? !tipo_adhesion.equals(that.tipo_adhesion) : that.tipo_adhesion != null)
            return false;
        return cuit_creacion != null ? cuit_creacion.equals(that.cuit_creacion) : that.cuit_creacion == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        result = 31 * result + (fechaCreacion != null ? fechaCreacion.hashCode() : 0);
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (activo != null ? activo.hashCode() : 0);
        result = 31 * result + (debin != null ? debin.hashCode() : 0);
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        result = 31 * result + (tipo_adhesion != null ? tipo_adhesion.hashCode() : 0);
        result = 31 * result + (cuit_creacion != null ? cuit_creacion.hashCode() : 0);
        return result;
    }
}
