package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Vendedor;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdherirVendedorRequest {

    private Vendedor vendedor;

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdherirVendedorRequest that = (AdherirVendedorRequest) o;

        return vendedor != null ? vendedor.equals(that.vendedor) : that.vendedor == null;
    }

    @Override
    public int hashCode() {
        return vendedor != null ? vendedor.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "AdherirVendedorRequest [" +
                "vendedor=" + vendedor +
                ']';
    }
}
