package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Comprador implements Serializable {

    private String codigo;
    private String titular;
    private String nombre;
    private String cuit;
    private Cuenta cuenta;
    private EstadoComprador estadoComprador;
    private String endpoint;
    private Contacto contacto;
    private String cbu;
    private String estado;

    public Comprador() {

    }

    /**
     * Convenience method para pruebas
     *
     * @param cuit
     * @param cbu
     * @param alias
     */
    public Comprador(String cuit, String cbu, String alias) {
        this.cuit = cuit;
        Cuenta cuenta = new Cuenta();
        cuenta.setCbu(cbu);
        cuenta.setAlias(alias);
        this.cuenta = cuenta;
    }


    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public EstadoComprador getEstadoComprador() {
        return estadoComprador;
    }

    public void setEstadoComprador(EstadoComprador estadoComprador) {
        this.estadoComprador = estadoComprador;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Contacto getContacto() {
        return contacto;
    }

    public void setContacto(Contacto contacto) {
        this.contacto = contacto;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    @Override
    public String toString() {
        return "Comprador [" +
                ((codigo != null) ? "codigo='" + codigo + "', " : "") +
                ((titular != null) ? "titular='" + titular + "', " : "") +
                ((nombre != null) ? "nombre='" + nombre + "', " : "") +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((cuenta != null) ? "cuenta=" + cuenta + ", " : "") +
                ((estadoComprador != null) ? "estadoComprador=" + estadoComprador + ", " : "") +
                ((endpoint != null) ? "endpoint='" + endpoint + "', " : "") +
                ((contacto != null) ? "contacto=" + contacto + ", " : "") +
                ((cbu != null) ? "cbu='" + cbu + "', " : "") +
                ((estado != null) ? "estado='" + estado + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Comprador comprador = (Comprador) o;
        return Objects.equals(codigo, comprador.codigo) && Objects.equals(titular, comprador.titular) && Objects.equals(nombre, comprador.nombre) && Objects.equals(cuit, comprador.cuit) && Objects.equals(cuenta, comprador.cuenta) && Objects.equals(estadoComprador, comprador.estadoComprador) && Objects.equals(endpoint, comprador.endpoint) && Objects.equals(contacto, comprador.contacto) && Objects.equals(cbu, comprador.cbu) && Objects.equals(estado, comprador.estado);
    }

    @Override
    public int hashCode() {
        return Objects.hash(codigo, titular, nombre, cuit, cuenta, estadoComprador, endpoint, contacto, cbu, estado);
    }
}