package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class CuentaAlias {

    @JsonProperty("nro_cbu")
    private String nroCbu;

    @JsonProperty("nro_cbu_anterior")
    private String nroCbuAnterior;

    @JsonProperty("nro_bco")
    private String nroBco;

    @JsonProperty("cta_activa")
    private String ctaActiva;

    @JsonProperty("tipo_cta")
    private DebinConst.TipoCuentaAlias tipoCta;

    public String getNroCbu() {
        return nroCbu;
    }

    public void setNroCbu(String nroCbu) {
        this.nroCbu = nroCbu;
    }

    public DebinConst.TipoCuentaAlias getTipoCta() {
        return tipoCta;
    }

    public void setTipoCta(DebinConst.TipoCuentaAlias tipoCta) {
        this.tipoCta = tipoCta;
    }

    public String getNroCbuAnterior() {
        return nroCbuAnterior;
    }

    public void setNroCbuAnterior(String nroCbuAnterior) {
        this.nroCbuAnterior = nroCbuAnterior;
    }

    public String getNroBco() {
        return nroBco;
    }

    public void setNroBco(String nroBco) {
        this.nroBco = nroBco;
    }

    public String getCtaActiva() {
        return ctaActiva;
    }

    public void setCtaActiva(String ctaActiva) {
        this.ctaActiva = ctaActiva;
    }

    @Override
    public String toString() {
        return "CuentaAlias [" +
                ((nroCbu != null) ? "nroCbu='" + nroCbu + "', " : "") +
                ((nroCbuAnterior != null) ? "nroCbuAnterior='" + nroCbuAnterior + "', " : "") +
                ((nroBco != null) ? "nroBco='" + nroBco + "', " : "") +
                ((ctaActiva != null) ? "ctaActiva='" + ctaActiva + "', " : "") +
                ((tipoCta != null) ? "tipoCta=" + tipoCta + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CuentaAlias that = (CuentaAlias) o;
        return Objects.equals(nroCbu, that.nroCbu) && Objects.equals(nroCbuAnterior, that.nroCbuAnterior) && Objects.equals(nroBco, that.nroBco) && Objects.equals(ctaActiva, that.ctaActiva) && tipoCta == that.tipoCta;
    }

    @Override
    public int hashCode() {
        return Objects.hash(nroCbu, nroCbuAnterior, nroBco, ctaActiva, tipoCta);
    }
}