package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
public class VendedorLimites {

    private String cuit;
    private BigDecimal impMaxARS;
    private BigDecimal cantMaxARS;
    private BigDecimal impMaxDLS;
    private BigDecimal cantMaxDLS;
    private BigDecimal impMaxGlobalARS;
    private BigDecimal cantMaxGlobalARS;
    private BigDecimal impMaxGlobalDLS;
    private BigDecimal cantMaxGlobalDLS;
    private Collection<LimiteBanco> limitesBanco;

    public VendedorLimites() {

    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public BigDecimal getImpMaxARS() {
        return impMaxARS;
    }

    public void setImpMaxARS(BigDecimal impMaxARS) {
        this.impMaxARS = impMaxARS;
    }

    public BigDecimal getCantMaxARS() {
        return cantMaxARS;
    }

    public void setCantMaxARS(BigDecimal cantMaxARS) {
        this.cantMaxARS = cantMaxARS;
    }

    public BigDecimal getImpMaxDLS() {
        return impMaxDLS;
    }

    public void setImpMaxDLS(BigDecimal impMaxDLS) {
        this.impMaxDLS = impMaxDLS;
    }

    public BigDecimal getCantMaxDLS() {
        return cantMaxDLS;
    }

    public void setCantMaxDLS(BigDecimal cantMaxDLS) {
        this.cantMaxDLS = cantMaxDLS;
    }

    public BigDecimal getImpMaxGlobalARS() {
        return impMaxGlobalARS;
    }

    public void setImpMaxGlobalARS(BigDecimal impMaxGlobalARS) {
        this.impMaxGlobalARS = impMaxGlobalARS;
    }

    public BigDecimal getCantMaxGlobalARS() {
        return cantMaxGlobalARS;
    }

    public void setCantMaxGlobalARS(BigDecimal cantMaxGlobalARS) {
        this.cantMaxGlobalARS = cantMaxGlobalARS;
    }

    public BigDecimal getImpMaxGlobalDLS() {
        return impMaxGlobalDLS;
    }

    public void setImpMaxGlobalDLS(BigDecimal impMaxGlobalDLS) {
        this.impMaxGlobalDLS = impMaxGlobalDLS;
    }

    public BigDecimal getCantMaxGlobalDLS() {
        return cantMaxGlobalDLS;
    }

    public void setCantMaxGlobalDLS(BigDecimal cantMaxGlobalDLS) {
        this.cantMaxGlobalDLS = cantMaxGlobalDLS;
    }

    public Collection<LimiteBanco> getLimitesBanco() {
        return limitesBanco;
    }

    public void setLimitesBanco(Collection<LimiteBanco> limitesBanco) {
        this.limitesBanco = limitesBanco;
    }

    @Override
    public String toString() {
        return "VendedorLimites ["
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((impMaxARS != null) ? "impMaxARS=" + impMaxARS + ", " : "")
                + ((cantMaxARS != null) ? "cantMaxARS=" + cantMaxARS + ", " : "")
                + ((impMaxDLS != null) ? "impMaxDLS=" + impMaxDLS + ", " : "")
                + ((cantMaxDLS != null) ? "cantMaxDLS=" + cantMaxDLS + ", " : "")
                + ((impMaxGlobalARS != null) ? "impMaxGlobalARS=" + impMaxGlobalARS + ", " : "")
                + ((cantMaxGlobalARS != null) ? "cantMaxGlobalARS=" + cantMaxGlobalARS + ", " : "")
                + ((impMaxGlobalDLS != null) ? "impMaxGlobalDLS=" + impMaxGlobalDLS + ", " : "")
                + ((cantMaxGlobalDLS != null) ? "cantMaxGlobalDLS=" + cantMaxGlobalDLS + ", " : "")
                + ((limitesBanco != null) ? "limitesBanco=" + Arrays.toString(limitesBanco.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VendedorLimites that = (VendedorLimites) o;

        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        if (impMaxARS != null ? !impMaxARS.equals(that.impMaxARS) : that.impMaxARS != null) return false;
        if (cantMaxARS != null ? !cantMaxARS.equals(that.cantMaxARS) : that.cantMaxARS != null) return false;
        if (impMaxDLS != null ? !impMaxDLS.equals(that.impMaxDLS) : that.impMaxDLS != null) return false;
        if (cantMaxDLS != null ? !cantMaxDLS.equals(that.cantMaxDLS) : that.cantMaxDLS != null) return false;
        if (impMaxGlobalARS != null ? !impMaxGlobalARS.equals(that.impMaxGlobalARS) : that.impMaxGlobalARS != null) return false;
        if (cantMaxGlobalARS != null ? !cantMaxGlobalARS.equals(that.cantMaxGlobalARS) : that.cantMaxGlobalARS != null) return false;
        if (impMaxGlobalDLS != null ? !impMaxGlobalDLS.equals(that.impMaxGlobalDLS) : that.impMaxGlobalDLS != null) return false;
        if (cantMaxGlobalDLS != null ? !cantMaxGlobalDLS.equals(that.cantMaxGlobalDLS) : that.cantMaxGlobalDLS != null) return false;
        return limitesBanco != null ? limitesBanco.equals(that.limitesBanco) : that.limitesBanco == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (impMaxARS != null ? impMaxARS.hashCode() : 0);
        result = 31 * result + (cantMaxARS != null ? cantMaxARS.hashCode() : 0);
        result = 31 * result + (impMaxDLS != null ? impMaxDLS.hashCode() : 0);
        result = 31 * result + (cantMaxDLS != null ? cantMaxDLS.hashCode() : 0);
        result = 31 * result + (impMaxGlobalARS != null ? impMaxGlobalARS.hashCode() : 0);
        result = 31 * result + (cantMaxGlobalARS != null ? cantMaxGlobalARS.hashCode() : 0);
        result = 31 * result + (impMaxGlobalDLS != null ? impMaxGlobalDLS.hashCode() : 0);
        result = 31 * result + (cantMaxGlobalDLS != null ? cantMaxGlobalDLS.hashCode() : 0);
        result = 31 * result + (limitesBanco != null ? limitesBanco.hashCode() : 0);
        return result;
    }
}
