package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Alias;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AltaCvuResponse {

    private Alias alias;
    private Respuesta respuesta;

    public AltaCvuResponse() {
    }

    public Alias getAlias() {
        return alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    @Override
    public String toString() {
        return "AltaCvuResponse ["
                + ((alias != null) ? "alias=" + alias + ", " : "")
                + ((respuesta != null) ? "respuesta=" + respuesta : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AltaCvuResponse that = (AltaCvuResponse) o;

        if (alias != null ? !alias.equals(that.alias) : that.alias != null) return false;
        return respuesta != null ? respuesta.equals(that.respuesta) : that.respuesta == null;
    }

    @Override
    public int hashCode() {
        int result = alias != null ? alias.hashCode() : 0;
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        return result;
    }
}
