
package ar.com.sdd.debin.io;


import ar.com.sdd.debin.entity.Evaluacion;
import ar.com.sdd.debin.entity.Operacion;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultarDebinResponse {

    private Operacion operacion;
    private Boolean preautorizado;
    private Evaluacion evaluacion;
    private Respuesta respuesta;

    public ConsultarDebinResponse() {
    }

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Boolean getPreautorizado() {
        return preautorizado;
    }

    public void setPreautorizado(Boolean preautorizado) {
        this.preautorizado = preautorizado;
    }

    public Evaluacion getEvaluacion() {
        return evaluacion;
    }

    public void setEvaluacion(Evaluacion evaluacion) {
        this.evaluacion = evaluacion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarDebinResponse that = (ConsultarDebinResponse) o;

        if (operacion != null ? !operacion.equals(that.operacion) : that.operacion != null) return false;
        if (preautorizado != null ? !preautorizado.equals(that.preautorizado) : that.preautorizado != null)
            return false;
        if (evaluacion != null ? !evaluacion.equals(that.evaluacion) : that.evaluacion != null) return false;
        return respuesta != null ? respuesta.equals(that.respuesta) : that.respuesta == null;
    }

    @Override
    public int hashCode() {
        int result = operacion != null ? operacion.hashCode() : 0;
        result = 31 * result + (preautorizado != null ? preautorizado.hashCode() : 0);
        result = 31 * result + (evaluacion != null ? evaluacion.hashCode() : 0);
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsultarDebinResponse [" +
                "operacion=" + operacion +
                ", preautorizado=" + preautorizado +
                ", evaluacion=" + evaluacion +
                ", respuesta=" + respuesta +
                ']';
    }
}
