package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class OperacionOriginal {

    private String id;
    private DebinConst.TipoDebin tipo;
    private Detalle detalle;

    public OperacionOriginal() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public Detalle getDetalle() {
        return detalle;
    }

    public void setDetalle(Detalle detalle) {
        this.detalle = detalle;
    }

    @Override
    public String toString() {
        return "OperacionOriginal [" +
                "id=" + id +
                ", tipo=" + tipo +
                ", detalle=" + detalle +
                ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        OperacionOriginal that = (OperacionOriginal) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (tipo != that.tipo) return false;
        return detalle != null ? detalle.equals(that.detalle) : that.detalle == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (detalle != null ? detalle.hashCode() : 0);
        return result;
    }
}
