package ar.com.sdd.debin.entity;

import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class TitularAlias {

    @JsonProperty("tipo_persona")
    private DebinConst.TipoPersonaAlias tipoPersona;

    private String cuit;

    private String nombre;

    public DebinConst.TipoPersonaAlias getTipoPersona() {
        return tipoPersona;
    }

    public void setTipoPersona(DebinConst.TipoPersonaAlias tipoPersona) {
        this.tipoPersona = tipoPersona;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getNombre() {
        return nombre;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Override
    public String toString() {
        return "TitularAlias [" +
                ((tipoPersona != null) ? "tipoPersona=" + tipoPersona + ", " : "") +
                ((cuit != null) ? "cuit='" + cuit + "', " : "") +
                ((nombre != null) ? "nombre='" + nombre + "', " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TitularAlias that = (TitularAlias) o;
        return tipoPersona == that.tipoPersona && Objects.equals(cuit, that.cuit) && Objects.equals(nombre, that.nombre);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tipoPersona, cuit, nombre);
    }
}