package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.CuentaActiva;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ConsultaCuentaEspecialBancoResponse {

    private Collection<CuentaActiva> cuentas;
    private Respuesta respuesta;

    public ConsultaCuentaEspecialBancoResponse() {
    }

    public Collection<CuentaActiva> getCuentas() {
        return cuentas;
    }

    public void setCuentas(Collection<CuentaActiva> cuentas) {
        this.cuentas = cuentas;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    @Override
    public String toString() {
        return "ConsultaCuentaEspecialBancoResponse ["
                + ((cuentas != null) ? "cuentas=" + Arrays.toString(cuentas.toArray()) + ", " : "")
                + ((respuesta != null) ? "respuesta=" + respuesta : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultaCuentaEspecialBancoResponse that = (ConsultaCuentaEspecialBancoResponse) o;

        if (cuentas != null ? !cuentas.equals(that.cuentas) : that.cuentas != null) return false;
        return respuesta != null ? respuesta.equals(that.respuesta) : that.respuesta == null;
    }

    @Override
    public int hashCode() {
        int result = cuentas != null ? cuentas.hashCode() : 0;
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        return result;
    }
}
