package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Alias;
import ar.com.sdd.debin.entity.CuentaAlias;
import ar.com.sdd.debin.entity.RespuestaAlias;
import ar.com.sdd.debin.entity.TitularAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

import java.util.Arrays;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)

public class ConsultarAliasResponse {

    private TitularAlias titular;
    private CuentaAlias cuenta;
    private RespuestaAlias respuesta;
    private Alias alias;
    private Collection<TitularAlias> titulares;
    private String transac;
    private String reasigna;

    public ConsultarAliasResponse() {
    }

    public CuentaAlias getCuenta() {
        return cuenta;
    }

    public void setCuenta(CuentaAlias cuenta) {
        this.cuenta = cuenta;
    }

    public TitularAlias getTitular() {
        return titular;
    }

    public void setTitular(TitularAlias titular) {
        this.titular = titular;
    }

    public RespuestaAlias getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(RespuestaAlias respuesta) {
        this.respuesta = respuesta;
    }

    public Alias getAlias() {
        return alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public Collection<TitularAlias> getTitulares() {
        return titulares;
    }

    public void setTitulares(Collection<TitularAlias> titulares) {
        this.titulares = titulares;
    }

    public String getTransac() {
        return transac;
    }

    public void setTransac(String transac) {
        this.transac = transac;
    }

    public String getReasigna() {
        return reasigna;
    }

    public void setReasigna(String reasigna) {
        this.reasigna = reasigna;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsultarAliasResponse that = (ConsultarAliasResponse) o;

        if (titular != null ? !titular.equals(that.titular) : that.titular != null) return false;
        if (cuenta != null ? !cuenta.equals(that.cuenta) : that.cuenta != null) return false;
        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (alias != null ? !alias.equals(that.alias) : that.alias != null) return false;
        if (titulares != null ? !titulares.equals(that.titulares) : that.titulares != null) return false;
        if (transac != null ? !transac.equals(that.transac) : that.transac != null) return false;
        return reasigna != null ? reasigna.equals(that.reasigna) : that.reasigna == null;
    }

    @Override
    public int hashCode() {
        int result = titular != null ? titular.hashCode() : 0;
        result = 31 * result + (cuenta != null ? cuenta.hashCode() : 0);
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        result = 31 * result + (alias != null ? alias.hashCode() : 0);
        result = 31 * result + (titulares != null ? titulares.hashCode() : 0);
        result = 31 * result + (transac != null ? transac.hashCode() : 0);
        result = 31 * result + (reasigna != null ? reasigna.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConsultarAliasResponse [" +
                "titular=" + titular +
                ", cuenta=" + cuenta +
                ", respuesta=" + respuesta +
                ", alias=" + alias +
                ", titulares=" + ((titulares != null) ? Arrays.toString(titulares.toArray()) : "") +
                ", transac=" + transac +
                ", reasigna=" + reasigna +
                ']';
    }
}
