package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Alias;
import ar.com.sdd.debin.entity.CuentaAlias;
import ar.com.sdd.debin.entity.TitularAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ModificarAliasRequest {

    private TitularAlias titular;
    private Alias alias;
    private CuentaAlias cuenta;

    public ModificarAliasRequest() {

    }

    public TitularAlias getTitular() {
        return titular;
    }

    public void setTitular(TitularAlias titular) {
        this.titular = titular;
    }

    public Alias getAlias() {
        return alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    public CuentaAlias getCuenta() {
        return cuenta;
    }

    public void setCuenta(CuentaAlias cuenta) {
        this.cuenta = cuenta;
    }

    @Override
    public String toString() {
        return "ModificarAliasRequest ["
                + ((titular != null) ? "titular=" + titular + ", " : "")
                + ((alias != null) ? "alias=" + alias + ", " : "")
                + ((cuenta != null) ? "cuenta=" + cuenta : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ModificarAliasRequest that = (ModificarAliasRequest) o;

        if (titular != null ? !titular.equals(that.titular) : that.titular != null) return false;
        if (alias != null ? !alias.equals(that.alias) : that.alias != null) return false;
        return cuenta != null ? cuenta.equals(that.cuenta) : that.cuenta == null;
    }

    @Override
    public int hashCode() {
        int result = titular != null ? titular.hashCode() : 0;
        result = 31 * result + (alias != null ? alias.hashCode() : 0);
        result = 31 * result + (cuenta != null ? cuenta.hashCode() : 0);
        return result;
    }
}
