package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;


import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Detalle implements Serializable {

    private DebinConst.Concepto concepto;
    private Integer idUsuario;
    private Integer idComprobante;
    private DebinConst.Moneda moneda;
    private BigDecimal importe;
    private Boolean devolucion;
    private String idOperacionOriginal;
    private Integer tiempoExpiracion;
    private String descripcion;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fecha;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaExpiracion;

    private String oriTrx;
    private String oriTerminal;
    private String oriAdicional;
    private Integer mismoTitular;
    private String motivo;
    private Long idLote;

    public DebinConst.Concepto getConcepto() {
        return concepto;
    }

    public void setConcepto(DebinConst.Concepto concepto) {
        this.concepto = concepto;
    }

    public Integer getIdUsuario() {
        return idUsuario;
    }

    public void setIdUsuario(Integer idUsuario) {
        this.idUsuario = idUsuario;
    }

    public Integer getIdComprobante() {
        return idComprobante;
    }

    public void setIdComprobante(Integer idComprobante) {
        this.idComprobante = idComprobante;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public Boolean getDevolucion() {
        return devolucion;
    }

    public void setDevolucion(Boolean devolucion) {
        this.devolucion = devolucion;
    }

    public String getIdOperacionOriginal() {
        return idOperacionOriginal;
    }

    public void setIdOperacionOriginal(String idOperacionOriginal) {
        this.idOperacionOriginal = idOperacionOriginal;
    }

    public Integer getTiempoExpiracion() {
        return tiempoExpiracion;
    }

    public void setTiempoExpiracion(Integer tiempoExpiracion) {
        this.tiempoExpiracion = tiempoExpiracion;
    }

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public Date getFecha() {
        return fecha;
    }

    public void setFecha(Date fecha) {
        this.fecha = fecha;
    }

    public Date getFechaExpiracion() {
        return fechaExpiracion;
    }

    public void setFechaExpiracion(Date fechaExpiracion) {
        this.fechaExpiracion = fechaExpiracion;
    }

    public String getOriTrx() {
        return oriTrx;
    }

    public void setOriTrx(String oriTrx) {
        this.oriTrx = oriTrx;
    }

    public String getOriTerminal() {
        return oriTerminal;
    }

    public void setOriTerminal(String oriTerminal) {
        this.oriTerminal = oriTerminal;
    }

    public String getOriAdicional() {
        return oriAdicional;
    }

    public void setOriAdicional(String oriAdicional) {
        this.oriAdicional = oriAdicional;
    }

    public Integer getMismoTitular() {
        return mismoTitular;
    }

    public void setMismoTitular(Integer mismoTitular) {
        this.mismoTitular = mismoTitular;
    }

    public String getMotivo() {
        return motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public Long getIdLote() {
        return idLote;
    }

    public void setIdLote(Long idLote) {
        this.idLote = idLote;
    }

    @Override
    public String toString() {
        return "Detalle [" +
                ((concepto != null) ? "concepto=" + concepto + ", " : "") +
                ((idUsuario != null) ? "idUsuario=" + idUsuario + ", " : "") +
                ((idComprobante != null) ? "idComprobante=" + idComprobante + ", " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((devolucion != null) ? "devolucion=" + devolucion + ", " : "") +
                ((idOperacionOriginal != null) ? "idOperacionOriginal='" + idOperacionOriginal + "', " : "") +
                ((tiempoExpiracion != null) ? "tiempoExpiracion=" + tiempoExpiracion + ", " : "") +
                ((descripcion != null) ? "descripcion='" + descripcion + "', " : "") +
                ((fecha != null) ? "fecha=" + fecha + ", " : "") +
                ((fechaExpiracion != null) ? "fechaExpiracion=" + fechaExpiracion + ", " : "") +
                ((oriTrx != null) ? "oriTrx='" + oriTrx + "', " : "") +
                ((oriTerminal != null) ? "oriTerminal='" + oriTerminal + "', " : "") +
                ((oriAdicional != null) ? "oriAdicional='" + oriAdicional + "', " : "") +
                ((mismoTitular != null) ? "mismoTitular=" + mismoTitular + ", " : "") +
                ((motivo != null) ? "motivo='" + motivo + "', " : "") +
                ((idLote != null) ? "idLote=" + idLote + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Detalle detalle = (Detalle) o;
        return concepto == detalle.concepto && Objects.equals(idUsuario, detalle.idUsuario) && Objects.equals(idComprobante, detalle.idComprobante) && moneda == detalle.moneda && Objects.equals(importe, detalle.importe) && Objects.equals(devolucion, detalle.devolucion) && Objects.equals(idOperacionOriginal, detalle.idOperacionOriginal) && Objects.equals(tiempoExpiracion, detalle.tiempoExpiracion) && Objects.equals(descripcion, detalle.descripcion) && Objects.equals(fecha, detalle.fecha) && Objects.equals(fechaExpiracion, detalle.fechaExpiracion) && Objects.equals(oriTrx, detalle.oriTrx) && Objects.equals(oriTerminal, detalle.oriTerminal) && Objects.equals(oriAdicional, detalle.oriAdicional) && Objects.equals(mismoTitular, detalle.mismoTitular) && Objects.equals(motivo, detalle.motivo) && Objects.equals(idLote, detalle.idLote);
    }

    @Override
    public int hashCode() {
        return Objects.hash(concepto, idUsuario, idComprobante, moneda, importe, devolucion, idOperacionOriginal, tiempoExpiracion, descripcion, fecha, fechaExpiracion, oriTrx, oriTerminal, oriAdicional, mismoTitular, motivo, idLote);
    }
}
