package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown = true)
public class LimiteBanco {

    private String banco;
    private BigDecimal impMaxARS;
    private BigDecimal cantMaxARS;
    private BigDecimal impMaxDLS;
    private BigDecimal cantMaxDLS;

    public LimiteBanco() {

    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public BigDecimal getImpMaxARS() {
        return impMaxARS;
    }

    public void setImpMaxARS(BigDecimal impMaxARS) {
        this.impMaxARS = impMaxARS;
    }

    public BigDecimal getCantMaxARS() {
        return cantMaxARS;
    }

    public void setCantMaxARS(BigDecimal cantMaxARS) {
        this.cantMaxARS = cantMaxARS;
    }

    public BigDecimal getImpMaxDLS() {
        return impMaxDLS;
    }

    public void setImpMaxDLS(BigDecimal impMaxDLS) {
        this.impMaxDLS = impMaxDLS;
    }

    public BigDecimal getCantMaxDLS() {
        return cantMaxDLS;
    }

    public void setCantMaxDLS(BigDecimal cantMaxDLS) {
        this.cantMaxDLS = cantMaxDLS;
    }

    @Override
    public String toString() {
        return "LimiteBanco ["
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((impMaxARS != null) ? "impMaxARS=" + impMaxARS + ", " : "")
                + ((cantMaxARS != null) ? "cantMaxARS=" + cantMaxARS + ", " : "")
                + ((impMaxDLS != null) ? "impMaxDLS=" + impMaxDLS + ", " : "")
                + ((cantMaxDLS != null) ? "cantMaxDLS=" + cantMaxDLS : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        LimiteBanco that = (LimiteBanco) o;

        if (banco != null ? !banco.equals(that.banco) : that.banco != null) return false;
        if (impMaxARS != null ? !impMaxARS.equals(that.impMaxARS) : that.impMaxARS != null) return false;
        if (cantMaxARS != null ? !cantMaxARS.equals(that.cantMaxARS) : that.cantMaxARS != null) return false;
        if (impMaxDLS != null ? !impMaxDLS.equals(that.impMaxDLS) : that.impMaxDLS != null) return false;
        return cantMaxDLS != null ? cantMaxDLS.equals(that.cantMaxDLS) : that.cantMaxDLS == null;
    }

    @Override
    public int hashCode() {
        int result = banco != null ? banco.hashCode() : 0;
        result = 31 * result + (impMaxARS != null ? impMaxARS.hashCode() : 0);
        result = 31 * result + (cantMaxARS != null ? cantMaxARS.hashCode() : 0);
        result = 31 * result + (impMaxDLS != null ? impMaxDLS.hashCode() : 0);
        result = 31 * result + (cantMaxDLS != null ? cantMaxDLS.hashCode() : 0);
        return result;
    }
}
