package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class Operacion {

    private String id;
    private DebinConst.TipoDebin tipo;
    private Comprador comprador;
    private Detalle detalle;
    private Vendedor vendedor;
    private Estado estado;
    private Boolean garantiaOk;
    private String tipoTransac;
    private Integer loteId;
    private Creacion creacion;
    @JsonProperty("ori_trx")
    private String oriTrx;
    @JsonProperty("ori_terminal")
    private String oriTerminal;
    @JsonProperty("ori_adicional")
    private String oriAdicional;
    private DatosGenerador datosGenerador;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaNegocio;
    private DebinConst.Moneda moneda;
    private BigDecimal importe;
    private String concepto;
    private Boolean devolucion;
    private String idOperacionOriginal;
    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date vencimiento;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DebinConst.TipoDebin getTipo() {
        return tipo;
    }

    public void setTipo(DebinConst.TipoDebin tipo) {
        this.tipo = tipo;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Detalle getDetalle() {
        return detalle;
    }

    public void setDetalle(Detalle detalle) {
        this.detalle = detalle;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Estado getEstado() {
        return estado;
    }

    public void setEstado(Estado estado) {
        this.estado = estado;
    }

    public Boolean getGarantiaOk() {
        return garantiaOk;
    }

    public void setGarantiaOk(Boolean garantiaOk) {
        this.garantiaOk = garantiaOk;
    }

    public String getTipoTransac() {
        return tipoTransac;
    }

    public void setTipoTransac(String tipoTransac) {
        this.tipoTransac = tipoTransac;
    }

    public Integer getLoteId() {
        return loteId;
    }

    public void setLoteId(Integer loteId) {
        this.loteId = loteId;
    }

    public Creacion getCreacion() {
        return creacion;
    }

    public void setCreacion(Creacion creacion) {
        this.creacion = creacion;
    }

    public String getOriTrx() {
        return oriTrx;
    }

    public void setOriTrx(String oriTrx) {
        this.oriTrx = oriTrx;
    }

    public String getOriTerminal() {
        return oriTerminal;
    }

    public void setOriTerminal(String oriTerminal) {
        this.oriTerminal = oriTerminal;
    }

    public String getOriAdicional() {
        return oriAdicional;
    }

    public void setOriAdicional(String oriAdicional) {
        this.oriAdicional = oriAdicional;
    }

    public DatosGenerador getDatosGenerador() {
        return datosGenerador;
    }

    public void setDatosGenerador(DatosGenerador datosGenerador) {
        this.datosGenerador = datosGenerador;
    }

    public Date getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(Date fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public BigDecimal getImporte() {
        return importe;
    }

    public void setImporte(BigDecimal importe) {
        this.importe = importe;
    }

    public String getConcepto() {
        return concepto;
    }

    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    public Boolean getDevolucion() {
        return devolucion;
    }

    public void setDevolucion(Boolean devolucion) {
        this.devolucion = devolucion;
    }

    public String getIdOperacionOriginal() {
        return idOperacionOriginal;
    }

    public void setIdOperacionOriginal(String idOperacionOriginal) {
        this.idOperacionOriginal = idOperacionOriginal;
    }

    public Date getVencimiento() {
        return vencimiento;
    }

    public void setVencimiento(Date vencimiento) {
        this.vencimiento = vencimiento;
    }

    @Override
    public String toString() {
        return "Operacion [" +
                ((id != null) ? "id='" + id + "', " : "") +
                ((tipo != null) ? "tipo=" + tipo + ", " : "") +
                ((comprador != null) ? "comprador=" + comprador + ", " : "") +
                ((detalle != null) ? "detalle=" + detalle + ", " : "") +
                ((vendedor != null) ? "vendedor=" + vendedor + ", " : "") +
                ((estado != null) ? "estado=" + estado + ", " : "") +
                ((garantiaOk != null) ? "garantiaOk=" + garantiaOk + ", " : "") +
                ((tipoTransac != null) ? "tipoTransac='" + tipoTransac + "', " : "") +
                ((loteId != null) ? "loteId=" + loteId + ", " : "") +
                ((creacion != null) ? "creacion=" + creacion + ", " : "") +
                ((oriTrx != null) ? "oriTrx='" + oriTrx + "', " : "") +
                ((oriTerminal != null) ? "oriTerminal='" + oriTerminal + "', " : "") +
                ((oriAdicional != null) ? "oriAdicional='" + oriAdicional + "', " : "") +
                ((datosGenerador != null) ? "datosGenerador=" + datosGenerador + ", " : "") +
                ((fechaNegocio != null) ? "fechaNegocio=" + fechaNegocio + ", " : "") +
                ((moneda != null) ? "moneda=" + moneda + ", " : "") +
                ((importe != null) ? "importe=" + importe + ", " : "") +
                ((concepto != null) ? "concepto='" + concepto + "', " : "") +
                ((devolucion != null) ? "devolucion=" + devolucion + ", " : "") +
                ((idOperacionOriginal != null) ? "idOperacionOriginal='" + idOperacionOriginal + "', " : "") +
                ((vencimiento != null) ? "vencimiento=" + vencimiento + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Operacion operacion = (Operacion) o;
        return Objects.equals(id, operacion.id) && tipo == operacion.tipo && Objects.equals(comprador, operacion.comprador) && Objects.equals(detalle, operacion.detalle) && Objects.equals(vendedor, operacion.vendedor) && Objects.equals(estado, operacion.estado) && Objects.equals(garantiaOk, operacion.garantiaOk) && Objects.equals(tipoTransac, operacion.tipoTransac) && Objects.equals(loteId, operacion.loteId) && Objects.equals(creacion, operacion.creacion) && Objects.equals(oriTrx, operacion.oriTrx) && Objects.equals(oriTerminal, operacion.oriTerminal) && Objects.equals(oriAdicional, operacion.oriAdicional) && Objects.equals(datosGenerador, operacion.datosGenerador) && Objects.equals(fechaNegocio, operacion.fechaNegocio) && moneda == operacion.moneda && Objects.equals(importe, operacion.importe) && Objects.equals(concepto, operacion.concepto) && Objects.equals(devolucion, operacion.devolucion) && Objects.equals(idOperacionOriginal, operacion.idOperacionOriginal) && Objects.equals(vencimiento, operacion.vencimiento);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, tipo, comprador, detalle, vendedor, estado, garantiaOk, tipoTransac, loteId, creacion, oriTrx, oriTerminal, oriAdicional, datosGenerador, fechaNegocio, moneda, importe, concepto, devolucion, idOperacionOriginal, vencimiento);
    }
}