package ar.com.sdd.debin.io;

import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.debin.core.DebinException;
import ar.com.sdd.debin.entity.Objeto;
import ar.com.sdd.debin.entity.Operacion;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CrearDebinRequest implements RequestValidation {

    private Objeto objeto;

    private Operacion operacion;

    public CrearDebinRequest() {
    }

    public CrearDebinRequest(Operacion operacion) {
        this.operacion = operacion;
    }

    public CrearDebinRequest(Objeto objeto, Operacion operacion) {
        this.operacion = operacion;
    }

    public Objeto getObjeto() {
        return objeto;
    }

    public void setObjeto(Objeto objeto) {
        this.objeto = objeto;
    }

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    @Override
    public void validate() throws DebinException {
        StringBuilder errors = new StringBuilder();
        if (operacion == null) {
            errors.append("|operacion null");
        } else {
            final boolean isDebinProgramado = operacion.getDetalle() != null && operacion.getDetalle().getDescripcion() != null && operacion.getDetalle().getDescripcion().matches("^[0-9]{3}/[0-9]{3}$");

            //Vendedor
            if (operacion.getVendedor() == null) {
                errors.append("|vendedor null");
            } else {
                if (StringUtils.isEmpty(operacion.getVendedor().getCuit())) {
                    errors.append("|vendedor.cuit empty");
                }
                if (StringUtils.isEmpty(operacion.getVendedor().getCbu())) {
                    errors.append("|vendedor.cbu empty");
                }
                if (StringUtils.isEmpty(operacion.getVendedor().getBanco())) {
                    errors.append("|vendedor.banco empty");
                }
                if (StringUtils.isEmpty(operacion.getVendedor().getTerminal())) {
                    errors.append("|vendedor.terminal empty");
                }

                if (isDebinProgramado) {
                    if (StringUtils.isEmpty(operacion.getVendedor().getPrestacion())) {
                        errors.append("|vendedor.prestacion empty");
                    }
                    if (operacion.getVendedor().getRecurrencia() == null) {
                        errors.append("|vendedor.recurrencia null");
                    }
                }
            }

            //Comprador
            if (operacion.getComprador() == null) {
                errors.append("|comprador null");
            } else {
                if (StringUtils.isEmpty(operacion.getComprador().getCuit())) {
                    errors.append("|comprador.cuit empty");
                }

                if (operacion.getComprador().getCuenta() == null) {
                    errors.append("|comprador.cuenta null");
                } else {
                    if (StringUtils.isEmpty(operacion.getComprador().getCuenta().getCbu())) {
                        errors.append("|comprador.cuenta.cbu empty");
                    }
                }
            }

            //Detalle
            if (operacion.getDetalle() == null) {
                errors.append("|detalle null");
            } else {
                if (operacion.getDetalle().getConcepto() == null) {
                    errors.append("|detalle.concepto null");
                }
                if (operacion.getDetalle().getMoneda() == null) {
                    errors.append("|detalle.moneda null");
                }
                if (operacion.getDetalle().getImporte() == null) {
                    errors.append("|detalle.importe null");
                }
                if (operacion.getDetalle().getTiempoExpiracion() == null) {
                    errors.append("|detalle.tiempoExpiracion null");
                }

                //FIXME Esto es un hack que pide Gire ya que no saben recibir idUsuario y idComprobante en null
                if (operacion.getDetalle().getIdUsuario() == null) {
                    operacion.getDetalle().setIdUsuario(0);
                }
                if (operacion.getDetalle().getIdComprobante() == null) {
                    operacion.getDetalle().setIdComprobante(0);
                }


                if (isDebinProgramado) {
                    if (operacion.getDetalle().getDevolucion() == null) {
                        errors.append("|detalle.devolucion null");
                    }
                    if (operacion.getDetalle().getMismoTitular() == null) {
                        // Indica si la operacion es entre cuentas del mismo titular:
                        // 0 = Distintos titulares
                        // 1 = Mismo titular
                        // 2 = Titular Parcial (cuenta compartida con otros titulares)
                        //FIXME Esto es un hack que pide Gire ya que no saben recibir mismoTitular en null
                        operacion.getDetalle().setMismoTitular(
                                operacion.getVendedor() != null && operacion.getComprador() != null && StringUtil.emptySafeEquals(operacion.getVendedor().getCuit(), operacion.getComprador().getCbu())
                                ? 1 : 0
                        );
                    } else if (operacion.getDetalle().getMismoTitular() < 0 || operacion.getDetalle().getMismoTitular() > 2) {
                        errors.append("|detalle.mismoTitular invalido (").append(operacion.getDetalle().getMismoTitular()).append("). Valores validos: 0|1|2");
                    }
                    if (operacion.getDetalle().getIdLote() == null) {
                        //FIXME Esto es un hack que pide Gire ya que no saben recibir idLote en null
                        operacion.getDetalle().setIdLote(0L);
                    }
                }
            }

            if (isDebinProgramado) {
                // Es un Debin Programado, valido un par de cosas mas
                //FIXME Esto es un hack que pide Gire ya que no saben recibir objeto en null
                if (objeto == null) {
                    objeto = new Objeto();
                    objeto.setOri_trx_id(0);
                }
            }
        }

        if (errors.length() > 0) {
            errors.insert(0, "Error de validacion en CrearDebinRequest:");
            throw new DebinException(errors.toString());
        }
    }

    @Override
    public String toString() {
        return "CrearDebinRequest [" +
                ((objeto != null) ? "objeto=" + objeto + ", " : "") +
                ((operacion != null) ? "operacion=" + operacion + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CrearDebinRequest that = (CrearDebinRequest) o;
        return Objects.equals(objeto, that.objeto) && Objects.equals(operacion, that.operacion);
    }

    @Override
    public int hashCode() {
        return Objects.hash(objeto, operacion);
    }
}