package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListarDebinResponse {

    private Listado listado;
    private Respuesta respuesta;
    private Collection<Operacion> operaciones;
    private List<Debin> debines;

    public ListarDebinResponse() {
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public List<Debin> getDebines() {
        return debines;
    }

    public void setDebines(List<Debin> debines) {
        this.debines = debines;
    }

    public Collection<Operacion> getOperaciones() {
        return operaciones;
    }

    public void setOperaciones(Collection<Operacion> operaciones) {
        this.operaciones = operaciones;
    }

    /**
     * Ojo que esta modificado
     *
     * @return
     */
    @Override
    public String toString() {
        return "ListarDebinResponse ["
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((operaciones != null) ? "operaciones size [" + operaciones.size() + "], operaciones(primeras 10)=" + Arrays.toString(Arrays.copyOfRange(operaciones.toArray(), 0, 10)) : "") //Solo imprimo las primeras 10
                + ((debines != null) ? "debines size [" + debines.size() + "], debines(primeros 10)=" + Arrays.toString(Arrays.copyOfRange(debines.toArray(), 0, 10)) : "") //Solo imprimo los primeros 10
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ListarDebinResponse that = (ListarDebinResponse) o;
        return Objects.equals(listado, that.listado) && Objects.equals(respuesta, that.respuesta) && Objects.equals(operaciones, that.operaciones) && Objects.equals(debines, that.debines);
    }

    @Override
    public int hashCode() {
        return Objects.hash(listado, respuesta, operaciones, debines);
    }
}
