package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ConsumoBanco {

    private String banco;
    private String impMaxARS;
    private String cantMaxARS;
    private String impMaxDLS;
    private String cantMaxDLS;

    public ConsumoBanco() {
    }

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getImpMaxARS() {
        return impMaxARS;
    }

    public void setImpMaxARS(String impMaxARS) {
        this.impMaxARS = impMaxARS;
    }

    public String getCantMaxARS() {
        return cantMaxARS;
    }

    public void setCantMaxARS(String cantMaxARS) {
        this.cantMaxARS = cantMaxARS;
    }

    public String getImpMaxDLS() {
        return impMaxDLS;
    }

    public void setImpMaxDLS(String impMaxDLS) {
        this.impMaxDLS = impMaxDLS;
    }

    public String getCantMaxDLS() {
        return cantMaxDLS;
    }

    public void setCantMaxDLS(String cantMaxDLS) {
        this.cantMaxDLS = cantMaxDLS;
    }

    @Override
    public String toString() {
        return "ConsumoBanco ["
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((impMaxARS != null) ? "impMaxARS=" + impMaxARS + ", " : "")
                + ((cantMaxARS != null) ? "cantMaxARS=" + cantMaxARS + ", " : "")
                + ((impMaxDLS != null) ? "impMaxDLS=" + impMaxDLS + ", " : "")
                + ((cantMaxDLS != null) ? "cantMaxDLS=" + cantMaxDLS : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ConsumoBanco that = (ConsumoBanco) o;

        if (banco != null ? !banco.equals(that.banco) : that.banco != null) return false;
        if (impMaxARS != null ? !impMaxARS.equals(that.impMaxARS) : that.impMaxARS != null) return false;
        if (cantMaxARS != null ? !cantMaxARS.equals(that.cantMaxARS) : that.cantMaxARS != null) return false;
        if (impMaxDLS != null ? !impMaxDLS.equals(that.impMaxDLS) : that.impMaxDLS != null) return false;
        return cantMaxDLS != null ? cantMaxDLS.equals(that.cantMaxDLS) : that.cantMaxDLS == null;
    }

    @Override
    public int hashCode() {
        int result = banco != null ? banco.hashCode() : 0;
        result = 31 * result + (impMaxARS != null ? impMaxARS.hashCode() : 0);
        result = 31 * result + (cantMaxARS != null ? cantMaxARS.hashCode() : 0);
        result = 31 * result + (impMaxDLS != null ? impMaxDLS.hashCode() : 0);
        result = 31 * result + (cantMaxDLS != null ? cantMaxDLS.hashCode() : 0);
        return result;
    }
}
