
package ar.com.sdd.debin.entity;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import ar.com.sdd.debin.core.DebinConst;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Cuenta {

    private String banco;
    private String sucursal;
    private String terminal;
    private String alias;
    private String cbu;
    private Boolean esTitular;
    private List<String> titulares;
    private DebinConst.Moneda moneda;
    private String tipo;
    private String endpointId;
    private String cuit;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date alta;

    public String getBanco() {
        return banco;
    }

    public void setBanco(String banco) {
        this.banco = banco;
    }

    public String getSucursal() {
        return sucursal;
    }

    public void setSucursal(String sucursal) {
        this.sucursal = sucursal;
    }

    public String getTerminal() {
        return terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public Boolean getEsTitular() {
        return esTitular;
    }

    public void setEsTitular(Boolean esTitular) {
        this.esTitular = esTitular;
    }

    public List<String> getTitulares() {
        return titulares;
    }

    public void setTitulares(List<String> titulares) {
        this.titulares = titulares;
    }

    public DebinConst.Moneda getMoneda() {
        return moneda;
    }

    public void setMoneda(DebinConst.Moneda moneda) {
        this.moneda = moneda;
    }

    public String getTipo() {
        return tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getEndpointId() {
        return endpointId;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public Date getAlta() {
        return alta;
    }

    public void setAlta(Date alta) {
        this.alta = alta;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    @Override
    public String toString() {
        return "Cuenta ["
                + ((banco != null) ? "banco=" + banco + ", " : "")
                + ((sucursal != null) ? "sucursal=" + sucursal + ", " : "")
                + ((terminal != null) ? "terminal=" + terminal + ", " : "")
                + ((alias != null) ? "alias=" + alias + ", " : "")
                + ((cbu != null) ? "cbu=" + cbu + ", " : "")
                + ((esTitular != null) ? "esTitular=" + esTitular + ", " : "")
                + ((titulares != null) ? "titulares=" + Arrays.toString(titulares.toArray()) + ", " : "")
                + ((moneda != null) ? "moneda=" + moneda + ", " : "")
                + ((tipo != null) ? "tipo=" + tipo + ", " : "")
                + ((endpointId != null) ? "endpointId=" + endpointId + ", " : "")
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((alta != null) ? "alta=" + alta : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Cuenta cuenta = (Cuenta) o;

        if (banco != null ? !banco.equals(cuenta.banco) : cuenta.banco != null) return false;
        if (sucursal != null ? !sucursal.equals(cuenta.sucursal) : cuenta.sucursal != null) return false;
        if (terminal != null ? !terminal.equals(cuenta.terminal) : cuenta.terminal != null) return false;
        if (alias != null ? !alias.equals(cuenta.alias) : cuenta.alias != null) return false;
        if (cbu != null ? !cbu.equals(cuenta.cbu) : cuenta.cbu != null) return false;
        if (esTitular != null ? !esTitular.equals(cuenta.esTitular) : cuenta.esTitular != null) return false;
        if (titulares != null ? !titulares.equals(cuenta.titulares) : cuenta.titulares != null) return false;
        if (moneda != cuenta.moneda) return false;
        if (tipo != null ? !tipo.equals(cuenta.tipo) : cuenta.tipo != null) return false;
        if (endpointId != null ? !endpointId.equals(cuenta.endpointId) : cuenta.endpointId != null) return false;
        if (cuit != null ? !cuit.equals(cuenta.cuit) : cuenta.cuit != null) return false;
        return alta != null ? alta.equals(cuenta.alta) : cuenta.alta == null;
    }

    @Override
    public int hashCode() {
        int result = banco != null ? banco.hashCode() : 0;
        result = 31 * result + (sucursal != null ? sucursal.hashCode() : 0);
        result = 31 * result + (terminal != null ? terminal.hashCode() : 0);
        result = 31 * result + (alias != null ? alias.hashCode() : 0);
        result = 31 * result + (cbu != null ? cbu.hashCode() : 0);
        result = 31 * result + (esTitular != null ? esTitular.hashCode() : 0);
        result = 31 * result + (titulares != null ? titulares.hashCode() : 0);
        result = 31 * result + (moneda != null ? moneda.hashCode() : 0);
        result = 31 * result + (tipo != null ? tipo.hashCode() : 0);
        result = 31 * result + (endpointId != null ? endpointId.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (alta != null ? alta.hashCode() : 0);
        return result;
    }
}
