package ar.com.sdd.debin.core;

/**
 * Determina el entorno de ejecucion, seteando las URLs correctas
 */
public enum DebinEnvironment {

    LOCALHOST("", "http://localhost:8080/sdd.debin/rest/debin/v1"),
    QA("", "http://test.debin.giresoluciones.com"),              //gire no tiene API de autenticacion
    PROD("", "http://debin.giresoluciones.com"),                 //gire no tiene API de autenticacion
    ;

    private String authBaseUrl;
    private String debinBaseUrl;

    DebinEnvironment(String authBaseUrl, String debinBaseUrl) {
        this.authBaseUrl = authBaseUrl;
        this.debinBaseUrl = debinBaseUrl;
    }

    public String getAuthBaseUrl() {
        return authBaseUrl;
    }

    public String getDebinBaseUrl() {
        return debinBaseUrl;
    }

}
