package ar.com.sdd.debin.io.apibancos;

import ar.com.sdd.commons.rest.util.ManyMillisecondsDateDeserializer;
import ar.com.sdd.commons.rest.util.ManyMillisecondsDateSerializer;
import ar.com.sdd.debin.entity.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CreditoResponse {

    private Respuesta respuesta;
    private Credito credito;
    private Importe importe;

    @JsonDeserialize(using = ManyMillisecondsDateDeserializer.class)
    @JsonSerialize(using = ManyMillisecondsDateSerializer.class)
    private Date fechaHoraEjecucion;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date fechaNegocio;

    private String dest_trx;
    private String dest_terminal;
    private String dest_adicional;
    private Integer dest_ori_trx_id;
    private Objeto objeto;
    private Evaluacion evaluacion;

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public Credito getCredito() {
        return credito;
    }

    public void setCredito(Credito credito) {
        this.credito = credito;
    }

    public Importe getImporte() {
        return importe;
    }

    public void setImporte(Importe importe) {
        this.importe = importe;
    }

    public Date getFechaHoraEjecucion() {
        return fechaHoraEjecucion;
    }

    public void setFechaHoraEjecucion(Date fechaHoraEjecucion) {
        this.fechaHoraEjecucion = fechaHoraEjecucion;
    }

    public String getDest_trx() {
        return dest_trx;
    }

    public void setDest_trx(String dest_trx) {
        this.dest_trx = dest_trx;
    }

    public String getDest_terminal() {
        return dest_terminal;
    }

    public void setDest_terminal(String dest_terminal) {
        this.dest_terminal = dest_terminal;
    }

    public String getDest_adicional() {
        return dest_adicional;
    }

    public void setDest_adicional(String dest_adicional) {
        this.dest_adicional = dest_adicional;
    }

    public Date getFechaNegocio() {
        return fechaNegocio;
    }

    public void setFechaNegocio(Date fechaNegocio) {
        this.fechaNegocio = fechaNegocio;
    }

    public Integer getDest_ori_trx_id() {
        return dest_ori_trx_id;
    }

    public void setDest_ori_trx_id(Integer dest_ori_trx_id) {
        this.dest_ori_trx_id = dest_ori_trx_id;
    }

    public Objeto getObjeto() {
        return objeto;
    }

    public void setObjeto(Objeto objeto) {
        this.objeto = objeto;
    }

    public Evaluacion getEvaluacion() {
        return evaluacion;
    }

    public void setEvaluacion(Evaluacion evaluacion) {
        this.evaluacion = evaluacion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CreditoResponse that = (CreditoResponse) o;

        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (credito != null ? !credito.equals(that.credito) : that.credito != null) return false;
        if (importe != null ? !importe.equals(that.importe) : that.importe != null) return false;
        if (fechaHoraEjecucion != null ? !fechaHoraEjecucion.equals(that.fechaHoraEjecucion) : that.fechaHoraEjecucion != null)
            return false;
        if (fechaNegocio != null ? !fechaNegocio.equals(that.fechaNegocio) : that.fechaNegocio != null) return false;
        if (dest_trx != null ? !dest_trx.equals(that.dest_trx) : that.dest_trx != null) return false;
        if (dest_terminal != null ? !dest_terminal.equals(that.dest_terminal) : that.dest_terminal != null)
            return false;
        if (dest_adicional != null ? !dest_adicional.equals(that.dest_adicional) : that.dest_adicional != null)
            return false;
        if (dest_ori_trx_id != null ? !dest_ori_trx_id.equals(that.dest_ori_trx_id) : that.dest_ori_trx_id != null)
            return false;
        if (objeto != null ? !objeto.equals(that.objeto) : that.objeto != null) return false;
        return evaluacion != null ? evaluacion.equals(that.evaluacion) : that.evaluacion == null;
    }

    @Override
    public int hashCode() {
        int result = respuesta != null ? respuesta.hashCode() : 0;
        result = 31 * result + (credito != null ? credito.hashCode() : 0);
        result = 31 * result + (importe != null ? importe.hashCode() : 0);
        result = 31 * result + (fechaHoraEjecucion != null ? fechaHoraEjecucion.hashCode() : 0);
        result = 31 * result + (fechaNegocio != null ? fechaNegocio.hashCode() : 0);
        result = 31 * result + (dest_trx != null ? dest_trx.hashCode() : 0);
        result = 31 * result + (dest_terminal != null ? dest_terminal.hashCode() : 0);
        result = 31 * result + (dest_adicional != null ? dest_adicional.hashCode() : 0);
        result = 31 * result + (dest_ori_trx_id != null ? dest_ori_trx_id.hashCode() : 0);
        result = 31 * result + (objeto != null ? objeto.hashCode() : 0);
        result = 31 * result + (evaluacion != null ? evaluacion.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "CreditoResponse [" +
                "respuesta=" + respuesta +
                ", credito=" + credito +
                ", importe=" + importe +
                ", fechaHoraEjecucion=" + fechaHoraEjecucion +
                ", fechaNegocio=" + fechaNegocio +
                ", dest_trx=" + dest_trx +
                ", dest_terminal=" + dest_terminal +
                ", dest_adicional=" + dest_adicional +
                ", dest_ori_trx_id=" + dest_ori_trx_id +
                ", objeto=" + objeto +
                ", evaluacion=" + evaluacion +
                ']';
    }
}
