package ar.com.sdd.debin.token;

import org.apache.commons.lang3.time.DateUtils;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

@XmlRootElement
public class DebinToken {

    /**
     * Se resetea la fecha de expiracion cuando se invoca a {@link #setExpiresIn(Integer)}
     */
    private Date expirationDate;

    private String scope;

    @XmlElement(name = "access_token")
    private String accessToken;

    @XmlElement(name = "token_type")
    private String tokenType;

    @XmlElement(name = "expires_in")
    private Integer expiresIn;


    public DebinToken() {

    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;

        //Reseteo la expiracion cuando se setea este campo
        resetExpirationDate(expiresIn);
    }


    private void resetExpirationDate(Integer expiresIn) {
        if (expiresIn != null) {
            //Le sumo los segundos que vinieron a la fecha actual
            Date now = new Date();
            expirationDate = DateUtils.addSeconds(now, expiresIn);
        }
    }

    public boolean isExpired() {
        return expirationDate == null || new Date().after(expirationDate);
    }

    @Override
    public String toString() {
        return "DebinToken [" +
                "expirationDate=" + expirationDate +
                ", scope=" + scope +
                ", accessToken=" + accessToken +
                ", tokenType=" + tokenType +
                ", expiresIn=" + expiresIn +
                ", expired=" + !isExpired() +
                ']';
    }
}
