package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class CuentaActiva {

    private Cuenta cuenta;
    private Boolean activo;

    public CuentaActiva() {

    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public Boolean getActivo() {
        return activo;
    }

    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Override
    public String toString() {
        return "CuentaActiva ["
                + ((cuenta != null) ? "cuenta=" + cuenta + ", " : "")
                + ((activo != null) ? "activo=" + activo : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CuentaActiva that = (CuentaActiva) o;

        if (cuenta != null ? !cuenta.equals(that.cuenta) : that.cuenta != null) return false;
        return activo != null ? activo.equals(that.activo) : that.activo == null;
    }

    @Override
    public int hashCode() {
        int result = cuenta != null ? cuenta.hashCode() : 0;
        result = 31 * result + (activo != null ? activo.hashCode() : 0);
        return result;
    }
}
