package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListarDebinRequest {

    private Listado listado;
    private Vendedor vendedor;
    private Comprador comprador;
    private Operacion operacion;
    private Debin debin;

    public ListarDebinRequest() {
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Vendedor getVendedor() {
        return vendedor;
    }

    public void setVendedor(Vendedor vendedor) {
        this.vendedor = vendedor;
    }

    public Comprador getComprador() {
        return comprador;
    }

    public void setComprador(Comprador comprador) {
        this.comprador = comprador;
    }

    public Debin getDebin() {
        return debin;
    }

    public void setDebin(Debin debin) {
        this.debin = debin;
    }

    public Operacion getOperacion() {
        return operacion;
    }

    public void setOperacion(Operacion operacion) {
        this.operacion = operacion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ListarDebinRequest that = (ListarDebinRequest) o;

        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        if (vendedor != null ? !vendedor.equals(that.vendedor) : that.vendedor != null) return false;
        if (comprador != null ? !comprador.equals(that.comprador) : that.comprador != null) return false;
        if (operacion != null ? !operacion.equals(that.operacion) : that.operacion != null) return false;
        return debin != null ? debin.equals(that.debin) : that.debin == null;
    }

    @Override
    public int hashCode() {
        int result = listado != null ? listado.hashCode() : 0;
        result = 31 * result + (vendedor != null ? vendedor.hashCode() : 0);
        result = 31 * result + (comprador != null ? comprador.hashCode() : 0);
        result = 31 * result + (operacion != null ? operacion.hashCode() : 0);
        result = 31 * result + (debin != null ? debin.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ListarDebinRequest [" +
                "listado=" + listado +
                ", vendedor=" + vendedor +
                ", comprador=" + comprador +
                ", operacion=" + operacion +
                ", debin=" + debin +
                ']';
    }
}
