package ar.com.sdd.debin.io;

import ar.com.sdd.debin.entity.Debin;
import ar.com.sdd.debin.entity.Listado;
import ar.com.sdd.debin.entity.Operaciones;
import ar.com.sdd.debin.entity.Respuesta;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ListarDebinResponse {

    private Listado listado;
    private Respuesta respuesta;
    private Collection<Operaciones> operaciones;
    private List<Debin> debines;

    public ListarDebinResponse() {
    }

    public Listado getListado() {
        return listado;
    }

    public void setListado(Listado listado) {
        this.listado = listado;
    }

    public Respuesta getRespuesta() {
        return respuesta;
    }

    public void setRespuesta(Respuesta respuesta) {
        this.respuesta = respuesta;
    }

    public List<Debin> getDebines() {
        return debines;
    }

    public void setDebines(List<Debin> debines) {
        this.debines = debines;
    }

    public Collection<Operaciones> getOperaciones() {
        return operaciones;
    }

    public void setOperaciones(Collection<Operaciones> operaciones) {
        this.operaciones = operaciones;
    }

    /**
     * Ojo que esta modificado
     *
     * @return
     */
    @Override
    public String toString() {
        return "ListarDebinResponse ["
                + ((listado != null) ? "listado=" + listado + ", " : "")
                + ((respuesta != null) ? "respuesta=" + respuesta + ", " : "")
                + ((operaciones != null) ? "operaciones size [" + operaciones.size() + "], operaciones(primeras 10)=" + Arrays.toString(Arrays.copyOfRange(operaciones.toArray(), 0, 10)) : "") //Solo imprimo las primeras 10
                + ((debines != null) ? "debines size [" + debines.size() + "], debines(primeros 10)=" + Arrays.toString(Arrays.copyOfRange(debines.toArray(), 0, 10)) : "") //Solo imprimo los primeros 10
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ListarDebinResponse that = (ListarDebinResponse) o;

        if (listado != null ? !listado.equals(that.listado) : that.listado != null) return false;
        if (respuesta != null ? !respuesta.equals(that.respuesta) : that.respuesta != null) return false;
        if (operaciones != null ? !operaciones.equals(that.operaciones) : that.operaciones != null) return false;
        return debines != null ? debines.equals(that.debines) : that.debines == null;
    }

    @Override
    public int hashCode() {
        int result = listado != null ? listado.hashCode() : 0;
        result = 31 * result + (respuesta != null ? respuesta.hashCode() : 0);
        result = 31 * result + (operaciones != null ? operaciones.hashCode() : 0);
        result = 31 * result + (debines != null ? debines.hashCode() : 0);
        return result;
    }
}
