package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EliminarPrestacionVendedorRequest {

    private String cuit;
    private String prestacion;

    public EliminarPrestacionVendedorRequest() {
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public String getPrestacion() {
        return prestacion;
    }

    public void setPrestacion(String prestacion) {
        this.prestacion = prestacion;
    }

    @Override
    public String toString() {
        return "EliminarPrestacionVendedorRequest ["
                + ((cuit != null) ? "cuit=" + cuit + ", " : "")
                + ((prestacion != null) ? "prestacion=" + prestacion : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EliminarPrestacionVendedorRequest that = (EliminarPrestacionVendedorRequest) o;

        if (cuit != null ? !cuit.equals(that.cuit) : that.cuit != null) return false;
        return prestacion != null ? prestacion.equals(that.prestacion) : that.prestacion == null;
    }

    @Override
    public int hashCode() {
        int result = cuit != null ? cuit.hashCode() : 0;
        result = 31 * result + (prestacion != null ? prestacion.hashCode() : 0);
        return result;
    }
}
