package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DatosGenerador {

    private String ipCliente;

    /**
     * 01 PC
     * 02 Telefono celular
     * 03 Table
     * 04 Otros
     */
    private String tipoDispositivo;

    /**
     * 01 Windows
     * 02 Android
     * 03 Linux
     * 04 Mac OS
     * 05 iOS
     * 06 Otros
     */
    private String plataforma;
    private String imsi;
    private String imei;
    private Ubicacion ubicacion;

    public DatosGenerador() {
    }

    public String getIpCliente() {
        return ipCliente;
    }

    public void setIpCliente(String ipCliente) {
        this.ipCliente = ipCliente;
    }

    public String getTipoDispositivo() {
        return tipoDispositivo;
    }

    public void setTipoDispositivo(String tipoDispositivo) {
        this.tipoDispositivo = tipoDispositivo;
    }

    public String getPlataforma() {
        return plataforma;
    }

    public void setPlataforma(String plataforma) {
        this.plataforma = plataforma;
    }

    public String getImsi() {
        return imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public Ubicacion getUbicacion() {
        return ubicacion;
    }

    public void setUbicacion(Ubicacion ubicacion) {
        this.ubicacion = ubicacion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DatosGenerador that = (DatosGenerador) o;

        if (ipCliente != null ? !ipCliente.equals(that.ipCliente) : that.ipCliente != null) return false;
        if (tipoDispositivo != null ? !tipoDispositivo.equals(that.tipoDispositivo) : that.tipoDispositivo != null)
            return false;
        if (plataforma != null ? !plataforma.equals(that.plataforma) : that.plataforma != null) return false;
        if (imsi != null ? !imsi.equals(that.imsi) : that.imsi != null) return false;
        if (imei != null ? !imei.equals(that.imei) : that.imei != null) return false;
        return ubicacion != null ? ubicacion.equals(that.ubicacion) : that.ubicacion == null;
    }

    @Override
    public int hashCode() {
        int result = ipCliente != null ? ipCliente.hashCode() : 0;
        result = 31 * result + (tipoDispositivo != null ? tipoDispositivo.hashCode() : 0);
        result = 31 * result + (plataforma != null ? plataforma.hashCode() : 0);
        result = 31 * result + (imsi != null ? imsi.hashCode() : 0);
        result = 31 * result + (imei != null ? imei.hashCode() : 0);
        result = 31 * result + (ubicacion != null ? ubicacion.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "DatosGenerador [" +
                "ipCliente=" + ipCliente +
                ", tipoDispositivo=" + tipoDispositivo +
                ", plataforma=" + plataforma +
                ", imsi=" + imsi +
                ", imei=" + imei +
                ", ubicacion=" + ubicacion +
                ']';
    }
}
