package ar.com.sdd.debin.io;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.*;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AdherirCompradorResponse {

    private String descripcion;
    /**
     00: OK
     63: Entidad Incorrecta
     09: Endpoint Incorrecto
     97: Datos inexistentes
     99: Error de Sistema
     */
    private String codigo;

    public String getDescripcion() {
        return descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdherirCompradorResponse that = (AdherirCompradorResponse) o;

        if (descripcion != null ? !descripcion.equals(that.descripcion) : that.descripcion != null) return false;
        return codigo != null ? codigo.equals(that.codigo) : that.codigo == null;
    }

    @Override
    public int hashCode() {
        int result = descripcion != null ? descripcion.hashCode() : 0;
        result = 31 * result + (codigo != null ? codigo.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "AdherirCompradorResponse [" +
                "descripcion=" + descripcion +
                ", codigo=" + codigo +
                ']';
    }
}
