
package ar.com.sdd.debin.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Comprador {

    private String codigo;
    private String titular;
    private String cuit;
    private Cuenta cuenta;
    private EstadoComprador estadoComprador;
    private String endpoint;
    private Contacto contacto;
    private String cbu;
    private String estado;

    public Comprador() {

    }

    /**
     * Convenience method para pruebas
     *
     * @param cuit
     * @param cbu
     * @param alias
     */
    public Comprador(String cuit, String cbu, String alias) {
        this.cuit = cuit;
        Cuenta cuenta = new Cuenta();
        cuenta.setCbu(cbu);
        cuenta.setAlias(alias);
        this.cuenta = cuenta;
    }


    public String getCodigo() {
        return codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getTitular() {
        return titular;
    }

    public void setTitular(String titular) {
        this.titular = titular;
    }

    public String getCuit() {
        return cuit;
    }

    public void setCuit(String cuit) {
        this.cuit = cuit;
    }

    public Cuenta getCuenta() {
        return cuenta;
    }

    public void setCuenta(Cuenta cuenta) {
        this.cuenta = cuenta;
    }

    public EstadoComprador getEstadoComprador() {
        return estadoComprador;
    }

    public void setEstadoComprador(EstadoComprador estadoComprador) {
        this.estadoComprador = estadoComprador;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public Contacto getContacto() {
        return contacto;
    }

    public void setContacto(Contacto contacto) {
        this.contacto = contacto;
    }

    public String getCbu() {
        return cbu;
    }

    public void setCbu(String cbu) {
        this.cbu = cbu;
    }

    public String getEstado() {
        return estado;
    }

    public void setEstado(String estado) {
        this.estado = estado;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Comprador comprador = (Comprador) o;

        if (codigo != null ? !codigo.equals(comprador.codigo) : comprador.codigo != null) return false;
        if (titular != null ? !titular.equals(comprador.titular) : comprador.titular != null) return false;
        if (cuit != null ? !cuit.equals(comprador.cuit) : comprador.cuit != null) return false;
        if (cuenta != null ? !cuenta.equals(comprador.cuenta) : comprador.cuenta != null) return false;
        if (estadoComprador != null ? !estadoComprador.equals(comprador.estadoComprador) : comprador.estadoComprador != null)
            return false;
        if (endpoint != null ? !endpoint.equals(comprador.endpoint) : comprador.endpoint != null) return false;
        if (contacto != null ? !contacto.equals(comprador.contacto) : comprador.contacto != null) return false;
        if (cbu != null ? !cbu.equals(comprador.cbu) : comprador.cbu != null) return false;
        return estado != null ? estado.equals(comprador.estado) : comprador.estado == null;
    }

    @Override
    public int hashCode() {
        int result = codigo != null ? codigo.hashCode() : 0;
        result = 31 * result + (titular != null ? titular.hashCode() : 0);
        result = 31 * result + (cuit != null ? cuit.hashCode() : 0);
        result = 31 * result + (cuenta != null ? cuenta.hashCode() : 0);
        result = 31 * result + (estadoComprador != null ? estadoComprador.hashCode() : 0);
        result = 31 * result + (endpoint != null ? endpoint.hashCode() : 0);
        result = 31 * result + (contacto != null ? contacto.hashCode() : 0);
        result = 31 * result + (cbu != null ? cbu.hashCode() : 0);
        result = 31 * result + (estado != null ? estado.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Comprador [" +
                "codigo=" + codigo +
                ", titular=" + titular +
                ", cuit=" + cuit +
                ", cuenta=" + cuenta +
                ", estadoComprador=" + estadoComprador +
                ", endpoint=" + endpoint +
                ", contacto=" + contacto +
                ", cbu=" + cbu +
                ", estado=" + estado +
                ']';
    }
}
