/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Map;
import java.util.StringTokenizer;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RightSetEbfApi
implements Serializable {
    private static final String ALL_RIGHTS = "*";
    private static final String ALL_RIGHTS_ALT = "|*|";
    private static final String TAG_ACCESS = "ACCESS";
    private static final String TAG_CONFIG = "CONFIG";
    private static final String DISABLED = "DISABLED";
    private boolean hasAccessToOtherCuits;
    private Map localRights;
    private Map effectiveRights;
    private String grupos;

    private static boolean isListAny(String listItems) {
        if (listItems.equals(ALL_RIGHTS)) {
            return true;
        }
        return listItems.equals(ALL_RIGHTS_ALT);
    }

    private Map getAnyTypeTable(Map topLevel, String type) {
        Map result = (Map)topLevel.get(type);
        if (result == null) {
            throw new RuntimeException("Error en RightSetWAPI: type no soportado:" + type);
        }
        return result;
    }

    private String getAnyRight(Map topLevel, String type, String tag) {
        return (String)this.getAnyTypeTable(topLevel, type).get(tag);
    }

    private boolean isInList(String listItems, String item, boolean allowPrefix) {
        boolean isInItems = false;
        if (listItems != null && item != null) {
            if (RightSetEbfApi.isListAny(listItems)) {
                isInItems = true;
            } else {
                StringTokenizer stDocTypes = new StringTokenizer(listItems, "|", false);
                while (stDocTypes.hasMoreTokens() && !isInItems) {
                    String token = stDocTypes.nextToken();
                    isInItems = allowPrefix ? item.startsWith(token) : item.equals(token);
                }
            }
        }
        return isInItems;
    }

    private boolean hasAnyRight(Map topLevel, String type, String tag, String value) {
        boolean newv;
        String tagValue;
        boolean retVal = false;
        retVal = value == null || "".equals(value) ? this.hasAnyRight(topLevel, type, tag) : ((tagValue = this.getAnyRight(topLevel, type, tag)) == null ? false : (ALL_RIGHTS.equals(tagValue) || ALL_RIGHTS_ALT.equals(tagValue) ? true : (newv = this.isInList(tagValue, value, false))));
        return retVal;
    }

    private boolean hasAnyRight(Map topLevel, String type, String tag) {
        Object val = this.getAnyTypeTable(topLevel, type).get(tag);
        if (val == null) {
            return false;
        }
        if (val instanceof String) {
            return !((String)val).equals(DISABLED);
        }
        return true;
    }

    private boolean hasEffectiveRight(String type, String tag) {
        return this.hasAnyRight(this.effectiveRights, type, tag);
    }

    private boolean hasAccessEffective(String tag) {
        return this.hasEffectiveRight(TAG_ACCESS, tag);
    }

    private boolean hasLocalRight(String type, String tag) {
        return this.hasAnyRight(this.localRights, type, tag);
    }

    private boolean hasAccessLocal(String tag) {
        return this.hasLocalRight(TAG_ACCESS, tag);
    }

    private boolean hasEffectiveRight(String type, String tag, String value) {
        return this.hasAnyRight(this.effectiveRights, type, tag, value);
    }

    private boolean hasConfigEffective(String tag, String value) {
        return this.hasEffectiveRight(TAG_CONFIG, tag, value);
    }

    private boolean hasLocalRight(String type, String tag, String value) {
        return this.hasAnyRight(this.localRights, type, tag, value);
    }

    private boolean hasConfigLocal(String tag, String value) {
        return this.hasLocalRight(TAG_CONFIG, tag, value);
    }

    public boolean hasAccess(String tag) {
        return this.hasAccessEffective(tag) || this.hasAccessLocal(tag);
    }

    public boolean hasConfig(String tag, String value) {
        return this.hasConfigEffective(tag, value) || this.hasConfigLocal(tag, value);
    }

    private String getEffectiveRight(String type, String tag) {
        return this.getAnyRight(this.effectiveRights, type, tag);
    }

    private String getLocalRight(String type, String tag) {
        return this.getAnyRight(this.localRights, type, tag);
    }

    public String getConfigEffective(String tag) {
        return this.getEffectiveRight(TAG_CONFIG, tag);
    }

    public String getConfigLocal(String tag) {
        return this.getLocalRight(TAG_CONFIG, tag);
    }

    public String getConfig(String tag) {
        String val = this.getConfigEffective(tag);
        if (val == null) {
            val = this.getConfigLocal(tag);
        }
        return val;
    }

    public Map getLocalRights() {
        return this.localRights;
    }

    public void setLocalRights(Map localRights) {
        this.localRights = localRights;
    }

    public Map getEffectiveRights() {
        return this.effectiveRights;
    }

    public void setEffectiveRights(Map effectiveRights) {
        this.effectiveRights = effectiveRights;
    }

    public boolean getHasAccessToOtherCuits() {
        return this.hasAccessToOtherCuits;
    }

    public void setHasAccessToOtherCuits(boolean hasAccessToOtherCuits) {
        this.hasAccessToOtherCuits = hasAccessToOtherCuits;
    }

    public boolean hasAccessToOtherCuits() {
        return this.hasAccessToOtherCuits;
    }

    public String getAccessGroup() {
        return this.grupos;
    }

    public void setAccessGroup(String grupos) {
        this.grupos = grupos;
    }

    public String toString() {
        return "RightSetEbfApi [hasAccessToOtherCuits=" + this.hasAccessToOtherCuits + ", " + (String)(this.localRights != null ? "localRights=" + this.localRights + ", " : "") + (String)(this.effectiveRights != null ? "effectiveRights=" + this.effectiveRights + ", " : "") + (String)(this.grupos != null ? "grupos=" + this.grupos : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RightSetEbfApi that = (RightSetEbfApi)o;
        if (this.hasAccessToOtherCuits != that.hasAccessToOtherCuits) {
            return false;
        }
        if (this.localRights != null ? !this.localRights.equals(that.localRights) : that.localRights != null) {
            return false;
        }
        if (this.effectiveRights != null ? !this.effectiveRights.equals(that.effectiveRights) : that.effectiveRights != null) {
            return false;
        }
        return this.grupos != null ? this.grupos.equals(that.grupos) : that.grupos == null;
    }

    public int hashCode() {
        int result = this.hasAccessToOtherCuits ? 1 : 0;
        result = 31 * result + (this.localRights != null ? this.localRights.hashCode() : 0);
        result = 31 * result + (this.effectiveRights != null ? this.effectiveRights.hashCode() : 0);
        result = 31 * result + (this.grupos != null ? this.grupos.hashCode() : 0);
        return result;
    }
}

