package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@JsonIgnoreProperties(ignoreUnknown = true)
public class DocumentEbfApi implements Serializable {

    private Long id;
    private String type;
    private String typeResource;
    private String subtype;
    private CompanyEbfApi owner;
    private CompanyEbfApi payer;
    private String ownerDocRef;
    private String ownerDocRef2;
    private String legalDocRef;
    private Date issueDate;
    private Date dueDate;
    private Date creationDate;
    private BigDecimal totalAmount;
    private BigDecimal dueAmount;
    private String currency;
    private String status;
    private String statusResource;
    private String reason;
    private String reasonName;
    private String reasonResource;
    private CompanyAccountEbfApi collectorAccount;
    private BankEbfApi issuerBank;
    private String comments;
    private String billingAddress;
    private String biltoName;
    private String editCodes;
    private Integer visibility;
    private String issuerName;
    private String postalCode;
    private BigDecimal financialDiscount1;
    private CompanyEbfApi division;

    //Campos extra
    private boolean selected;

    public DocumentEbfApi() {
    }

    public DocumentEbfApi(Long id, String type, CompanyEbfApi owner, CompanyEbfApi payer, String legalDocRef, Date dueDate, BigDecimal dueAmount) {
        this.id = id;
        this.type = type;
        this.owner = owner;
        this.payer = payer;
        this.legalDocRef = legalDocRef;
        this.dueDate = dueDate;
        this.dueAmount = dueAmount;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeResource() {
        return typeResource;
    }

    public void setTypeResource(String typeResource) {
        this.typeResource = typeResource;
    }

    public String getSubtype() {
        return subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public CompanyEbfApi getOwner() {
        return owner;
    }

    public void setOwner(CompanyEbfApi owner) {
        this.owner = owner;
    }

    public CompanyEbfApi getPayer() {
        return payer;
    }

    public void setPayer(CompanyEbfApi payer) {
        this.payer = payer;
    }

    public String getOwnerDocRef() {
        return ownerDocRef;
    }

    public void setOwnerDocRef(String ownerDocRef) {
        this.ownerDocRef = ownerDocRef;
    }

    public String getOwnerDocRef2() {
        return ownerDocRef2;
    }

    public void setOwnerDocRef2(String ownerDocRef2) {
        this.ownerDocRef2 = ownerDocRef2;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public Date getIssueDate() {
        return issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public Date getDueDate() {
        return dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getDueAmount() {
        return dueAmount;
    }

    public void setDueAmount(BigDecimal dueAmount) {
        this.dueAmount = dueAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusResource() {
        return statusResource;
    }

    public void setStatusResource(String statusResource) {
        this.statusResource = statusResource;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getReasonName() {
        return reasonName;
    }

    public void setReasonName(String reasonName) {
        this.reasonName = reasonName;
    }

    public String getReasonResource() {
        return reasonResource;
    }

    public void setReasonResource(String reasonResource) {
        this.reasonResource = reasonResource;
    }

    public CompanyAccountEbfApi getCollectorAccount() {
        return collectorAccount;
    }

    public void setCollectorAccount(CompanyAccountEbfApi collectorAccount) {
        this.collectorAccount = collectorAccount;
    }

    public BankEbfApi getIssuerBank() {
        return issuerBank;
    }

    public void setIssuerBank(BankEbfApi issuerBank) {
        this.issuerBank = issuerBank;
    }

    public String getComments() {
        return comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getBillingAddress() {
        return billingAddress;
    }

    public void setBillingAddress(String billingAddress) {
        this.billingAddress = billingAddress;
    }

    public String getBiltoName() {
        return biltoName;
    }

    public void setBiltoName(String biltoName) {
        this.biltoName = biltoName;
    }

    public String getEditCodes() {
        return editCodes;
    }

    public void setEditCodes(String editCodes) {
        this.editCodes = editCodes;
    }

    public Integer getVisibility() {
        return visibility;
    }

    public void setVisibility(Integer visibility) {
        this.visibility = visibility;
    }

    public String getIssuerName() {
        return issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String getPostalCode() {
        return postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public BigDecimal getFinancialDiscount1() {
        return financialDiscount1;
    }

    public void setFinancialDiscount1(BigDecimal financialDiscount1) {
        this.financialDiscount1 = financialDiscount1;
    }

    public CompanyEbfApi getDivision() {
        return division;
    }

    public void setDivision(CompanyEbfApi division) {
        this.division = division;
    }

    public boolean isSelected() {
        return selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public String toString() {
        return "DocumentEbfApi ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((type != null) ? "type=" + type + ", " : "")
                + ((typeResource != null) ? "typeResource=" + typeResource + ", " : "")
                + ((subtype != null) ? "subtype=" + subtype + ", " : "")
                + ((owner != null) ? "owner=" + owner + ", " : "")
                + ((payer != null) ? "payer=" + payer + ", " : "")
                + ((ownerDocRef != null) ? "ownerDocRef=" + ownerDocRef + ", " : "")
                + ((ownerDocRef2 != null) ? "ownerDocRef2=" + ownerDocRef2 + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((issueDate != null) ? "issueDate=" + issueDate + ", " : "")
                + ((dueDate != null) ? "dueDate=" + dueDate + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((totalAmount != null) ? "totalAmount=" + totalAmount + ", " : "")
                + ((dueAmount != null) ? "dueAmount=" + dueAmount + ", " : "")
                + ((currency != null) ? "currency=" + currency + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((statusResource != null) ? "statusResource=" + statusResource + ", " : "")
                + ((reason != null) ? "reason=" + reason + ", " : "")
                + ((reasonName != null) ? "reasonName=" + reasonName + ", " : "")
                + ((reasonResource != null) ? "reasonResource=" + reasonResource + ", " : "")
                + ((collectorAccount != null) ? "collectorAccount=" + collectorAccount + ", " : "")
                + ((issuerBank != null) ? "issuerBank=" + issuerBank + ", " : "")
                + ((comments != null) ? "comments=" + comments + ", " : "")
                + ((billingAddress != null) ? "billingAddress=" + billingAddress + ", " : "")
                + ((biltoName != null) ? "biltoName=" + biltoName + ", " : "")
                + ((editCodes != null) ? "editCodes=" + editCodes + ", " : "")
                + ((visibility != null) ? "visibility=" + visibility + ", " : "")
                + ((issuerName != null) ? "issuerName=" + issuerName + ", " : "")
                + ((postalCode != null) ? "postalCode=" + postalCode + ", " : "")
                + ((financialDiscount1 != null) ? "financialDiscount1=" + financialDiscount1 + ", " : "")
                + ((division != null) ? "division=" + division + ", " : "")
                + "selected=" + selected
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DocumentEbfApi that = (DocumentEbfApi) o;

        if (selected != that.selected) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (type != null ? !type.equals(that.type) : that.type != null) return false;
        if (typeResource != null ? !typeResource.equals(that.typeResource) : that.typeResource != null) return false;
        if (subtype != null ? !subtype.equals(that.subtype) : that.subtype != null) return false;
        if (owner != null ? !owner.equals(that.owner) : that.owner != null) return false;
        if (payer != null ? !payer.equals(that.payer) : that.payer != null) return false;
        if (ownerDocRef != null ? !ownerDocRef.equals(that.ownerDocRef) : that.ownerDocRef != null) return false;
        if (ownerDocRef2 != null ? !ownerDocRef2.equals(that.ownerDocRef2) : that.ownerDocRef2 != null) return false;
        if (legalDocRef != null ? !legalDocRef.equals(that.legalDocRef) : that.legalDocRef != null) return false;
        if (issueDate != null ? !issueDate.equals(that.issueDate) : that.issueDate != null) return false;
        if (dueDate != null ? !dueDate.equals(that.dueDate) : that.dueDate != null) return false;
        if (creationDate != null ? !creationDate.equals(that.creationDate) : that.creationDate != null) return false;
        if (totalAmount != null ? !totalAmount.equals(that.totalAmount) : that.totalAmount != null) return false;
        if (dueAmount != null ? !dueAmount.equals(that.dueAmount) : that.dueAmount != null) return false;
        if (currency != null ? !currency.equals(that.currency) : that.currency != null) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (statusResource != null ? !statusResource.equals(that.statusResource) : that.statusResource != null) return false;
        if (reason != null ? !reason.equals(that.reason) : that.reason != null) return false;
        if (reasonName != null ? !reasonName.equals(that.reasonName) : that.reasonName != null) return false;
        if (reasonResource != null ? !reasonResource.equals(that.reasonResource) : that.reasonResource != null) return false;
        if (collectorAccount != null ? !collectorAccount.equals(that.collectorAccount) : that.collectorAccount != null) return false;
        if (issuerBank != null ? !issuerBank.equals(that.issuerBank) : that.issuerBank != null) return false;
        if (comments != null ? !comments.equals(that.comments) : that.comments != null) return false;
        if (billingAddress != null ? !billingAddress.equals(that.billingAddress) : that.billingAddress != null) return false;
        if (biltoName != null ? !biltoName.equals(that.biltoName) : that.biltoName != null) return false;
        if (editCodes != null ? !editCodes.equals(that.editCodes) : that.editCodes != null) return false;
        if (visibility != null ? !visibility.equals(that.visibility) : that.visibility != null) return false;
        if (issuerName != null ? !issuerName.equals(that.issuerName) : that.issuerName != null) return false;
        if (postalCode != null ? !postalCode.equals(that.postalCode) : that.postalCode != null) return false;
        if (financialDiscount1 != null ? !financialDiscount1.equals(that.financialDiscount1) : that.financialDiscount1 != null) return false;
        return division != null ? division.equals(that.division) : that.division == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (typeResource != null ? typeResource.hashCode() : 0);
        result = 31 * result + (subtype != null ? subtype.hashCode() : 0);
        result = 31 * result + (owner != null ? owner.hashCode() : 0);
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (ownerDocRef != null ? ownerDocRef.hashCode() : 0);
        result = 31 * result + (ownerDocRef2 != null ? ownerDocRef2.hashCode() : 0);
        result = 31 * result + (legalDocRef != null ? legalDocRef.hashCode() : 0);
        result = 31 * result + (issueDate != null ? issueDate.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (creationDate != null ? creationDate.hashCode() : 0);
        result = 31 * result + (totalAmount != null ? totalAmount.hashCode() : 0);
        result = 31 * result + (dueAmount != null ? dueAmount.hashCode() : 0);
        result = 31 * result + (currency != null ? currency.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (statusResource != null ? statusResource.hashCode() : 0);
        result = 31 * result + (reason != null ? reason.hashCode() : 0);
        result = 31 * result + (reasonName != null ? reasonName.hashCode() : 0);
        result = 31 * result + (reasonResource != null ? reasonResource.hashCode() : 0);
        result = 31 * result + (collectorAccount != null ? collectorAccount.hashCode() : 0);
        result = 31 * result + (issuerBank != null ? issuerBank.hashCode() : 0);
        result = 31 * result + (comments != null ? comments.hashCode() : 0);
        result = 31 * result + (billingAddress != null ? billingAddress.hashCode() : 0);
        result = 31 * result + (biltoName != null ? biltoName.hashCode() : 0);
        result = 31 * result + (editCodes != null ? editCodes.hashCode() : 0);
        result = 31 * result + (visibility != null ? visibility.hashCode() : 0);
        result = 31 * result + (issuerName != null ? issuerName.hashCode() : 0);
        result = 31 * result + (postalCode != null ? postalCode.hashCode() : 0);
        result = 31 * result + (financialDiscount1 != null ? financialDiscount1.hashCode() : 0);
        result = 31 * result + (division != null ? division.hashCode() : 0);
        result = 31 * result + (selected ? 1 : 0);
        return result;
    }
}
