package ar.com.sdd.ebfapi.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Representa una celda de la pantalla de resumen o consola
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class CellEbfApi implements Serializable {

    public enum ConsoleCellType {
        HEADER_TITLE,
        ROW_TITLE,
        IMG,
        EMPTY,
        STRING,
        BIG_DECIMAL,
        CURRENCY,
        INTEGER,
        LONG,
        DATE
    }

    public enum ConsoleCellAlign {
        CENTER,
        LEFT,
        RIGHT
    }


    private ConsoleCellType cellType;
    private ConsoleCellAlign align;

    private String stringValue;
    private BigDecimal bigDecimalValue;
    private BigDecimal currencyValue;
    private Integer integerValue;
    private Long longValue;
    private Date dateValue;
    private String imageResourceName;


    public CellEbfApi() {

    }

    public static CellEbfApi headerTitle(String stringValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.HEADER_TITLE);
        cell.setStringValue(stringValue);
        cell.setAlign(ConsoleCellAlign.CENTER);
        return cell;
    }

    public static CellEbfApi rowTitle(String stringValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.ROW_TITLE);
        cell.setStringValue(stringValue);
        cell.setAlign(ConsoleCellAlign.LEFT);
        return cell;
    }

    public static CellEbfApi img(String imageResourceName) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.IMG);
        cell.setImageResourceName(imageResourceName);
        cell.setAlign(ConsoleCellAlign.CENTER);
        return cell;
    }

    public static CellEbfApi empty() {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.EMPTY);
        return cell;
    }

    public static CellEbfApi string(String stringValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.STRING);
        cell.setStringValue(stringValue);
        cell.setAlign(ConsoleCellAlign.LEFT);
        return cell;
    }

    public static CellEbfApi bigDecimal(BigDecimal bigDecimalValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.BIG_DECIMAL);
        cell.setBigDecimalValue(bigDecimalValue);
        cell.setAlign(ConsoleCellAlign.RIGHT);
        return cell;
    }

    public static CellEbfApi currency(BigDecimal currencyValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.CURRENCY);
        cell.setCurrencyValue(currencyValue);
        cell.setAlign(ConsoleCellAlign.RIGHT);
        return cell;
    }

    public static CellEbfApi integer(Integer integerValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.INTEGER);
        cell.setIntegerValue(integerValue);
        cell.setAlign(ConsoleCellAlign.RIGHT);
        return cell;
    }

    public static CellEbfApi lng(Long longValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.LONG);
        cell.setLongValue(longValue);
        cell.setAlign(ConsoleCellAlign.RIGHT);
        return cell;
    }

    public static CellEbfApi date(Date dateValue) {
        CellEbfApi cell = new CellEbfApi();
        cell.setCellType(ConsoleCellType.DATE);
        cell.setDateValue(dateValue);
        cell.setAlign(ConsoleCellAlign.CENTER);
        return cell;
    }

    public ConsoleCellType getCellType() {
        return cellType;
    }

    public void setCellType(ConsoleCellType cellType) {
        this.cellType = cellType;
    }

    public String getStringValue() {
        return stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public BigDecimal getBigDecimalValue() {
        return bigDecimalValue;
    }

    public void setBigDecimalValue(BigDecimal bigDecimalValue) {
        this.bigDecimalValue = bigDecimalValue;
    }

    public BigDecimal getCurrencyValue() {
        return currencyValue;
    }

    public void setCurrencyValue(BigDecimal currencyValue) {
        this.currencyValue = currencyValue;
    }

    public Integer getIntegerValue() {
        return integerValue;
    }

    public void setIntegerValue(Integer integerValue) {
        this.integerValue = integerValue;
    }

    public Date getDateValue() {
        return dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
    }

    public String getImageResourceName() {
        return imageResourceName;
    }

    public void setImageResourceName(String imageResourceName) {
        this.imageResourceName = imageResourceName;
    }

    public ConsoleCellAlign getAlign() {
        return align;
    }

    public void setAlign(ConsoleCellAlign align) {
        this.align = align;
    }

    public Long getLongValue() {
        return longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public String toString() {
        return "CellEbfApi ["
                + ((cellType != null) ? "cellType=" + cellType + ", " : "")
                + ((stringValue != null) ? "stringValue=" + stringValue + ", " : "")
                + ((bigDecimalValue != null) ? "bigDecimalValue=" + bigDecimalValue + ", " : "")
                + ((currencyValue != null) ? "currencyValue=" + currencyValue + ", " : "")
                + ((integerValue != null) ? "integerValue=" + integerValue + ", " : "")
                + ((longValue != null) ? "longValue=" + longValue + ", " : "")
                + ((dateValue != null) ? "dateValue=" + dateValue + ", " : "")
                + ((imageResourceName != null) ? "imageResourceName=" + imageResourceName + ", " : "")
                + ((align != null) ? "align=" + align : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CellEbfApi that = (CellEbfApi) o;

        if (cellType != that.cellType) return false;
        if (stringValue != null ? !stringValue.equals(that.stringValue) : that.stringValue != null) return false;
        if (bigDecimalValue != null ? !bigDecimalValue.equals(that.bigDecimalValue) : that.bigDecimalValue != null) return false;
        if (currencyValue != null ? !currencyValue.equals(that.currencyValue) : that.currencyValue != null) return false;
        if (integerValue != null ? !integerValue.equals(that.integerValue) : that.integerValue != null) return false;
        if (longValue != null ? !longValue.equals(that.longValue) : that.longValue != null) return false;
        if (dateValue != null ? !dateValue.equals(that.dateValue) : that.dateValue != null) return false;
        if (imageResourceName != null ? !imageResourceName.equals(that.imageResourceName) : that.imageResourceName != null) return false;
        return align == that.align;
    }

    @Override
    public int hashCode() {
        int result = cellType != null ? cellType.hashCode() : 0;
        result = 31 * result + (stringValue != null ? stringValue.hashCode() : 0);
        result = 31 * result + (bigDecimalValue != null ? bigDecimalValue.hashCode() : 0);
        result = 31 * result + (currencyValue != null ? currencyValue.hashCode() : 0);
        result = 31 * result + (integerValue != null ? integerValue.hashCode() : 0);
        result = 31 * result + (longValue != null ? longValue.hashCode() : 0);
        result = 31 * result + (dateValue != null ? dateValue.hashCode() : 0);
        result = 31 * result + (imageResourceName != null ? imageResourceName.hashCode() : 0);
        result = 31 * result + (align != null ? align.hashCode() : 0);
        return result;
    }
}
