package ar.com.sdd.ebfapi.client.model.erp;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown = true)
public class ErpPayment implements Serializable {

    private String type;
    private String legalDocRef;
    private List<ErpDocument> erpDocuments;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT-03:00")
    private Date creationDate;
    private BigDecimal exchangeRate;
    private String status;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLegalDocRef() {
        return legalDocRef;
    }

    public void setLegalDocRef(String legalDocRef) {
        this.legalDocRef = legalDocRef;
    }

    public List<ErpDocument> getErpDocuments() {
        return erpDocuments;
    }

    public void setErpDocuments(List<ErpDocument> erpDocuments) {
        this.erpDocuments = erpDocuments;
    }

    public Date getCreationDate() {
        return creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "ErpPayment ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((legalDocRef != null) ? "legalDocRef=" + legalDocRef + ", " : "")
                + ((erpDocuments != null) ? "erpDocuments=" + Arrays.toString(erpDocuments.toArray()) + ", " : "")
                + ((creationDate != null) ? "creationDate=" + creationDate + ", " : "")
                + ((exchangeRate != null) ? "exchangeRate=" + exchangeRate + ", " : "")
                + ((status != null) ? "status=" + status : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ErpPayment that = (ErpPayment) o;

        if (type != null ? !type.equals(that.type) : that.type != null) return false;
        if (legalDocRef != null ? !legalDocRef.equals(that.legalDocRef) : that.legalDocRef != null) return false;
        if (erpDocuments != null ? !erpDocuments.equals(that.erpDocuments) : that.erpDocuments != null) return false;
        if (creationDate != null ? !creationDate.equals(that.creationDate) : that.creationDate != null) return false;
        if (exchangeRate != null ? !exchangeRate.equals(that.exchangeRate) : that.exchangeRate != null) return false;
        return status != null ? status.equals(that.status) : that.status == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (legalDocRef != null ? legalDocRef.hashCode() : 0);
        result = 31 * result + (erpDocuments != null ? erpDocuments.hashCode() : 0);
        result = 31 * result + (creationDate != null ? creationDate.hashCode() : 0);
        result = 31 * result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        return result;
    }
}
